/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.micro.mall.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.micro.mall.model.StockOutOrder;
import com.ptteng.micro.mall.service.StockOutOrderService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StockOutOrderServiceImpl
extends BaseDaoServiceImpl
implements StockOutOrderService {
    private static final Log log = LogFactory.getLog(StockOutOrderServiceImpl.class);

    public Long insert(StockOutOrder stockOutOrder) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + stockOutOrder));
        if (stockOutOrder == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        stockOutOrder.setCreateAt(Long.valueOf(currentTimeMillis));
        stockOutOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)stockOutOrder);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + stockOutOrder));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<StockOutOrder> insertList(List<StockOutOrder> stockOutOrderList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (stockOutOrderList == null ? "null" : Integer.valueOf(stockOutOrderList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(stockOutOrderList)) {
            return new ArrayList<StockOutOrder>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (StockOutOrder stockOutOrder : stockOutOrderList) {
            stockOutOrder.setCreateAt(Long.valueOf(currentTimeMillis));
            stockOutOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(stockOutOrderList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + stockOutOrderList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(StockOutOrder.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(StockOutOrder stockOutOrder) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (stockOutOrder == null ? "null" : stockOutOrder.getId())));
        boolean result = false;
        if (stockOutOrder == null) {
            return true;
        }
        stockOutOrder.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)stockOutOrder);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + stockOutOrder));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + stockOutOrder));
        }
        return result;
    }

    public boolean updateList(List<StockOutOrder> stockOutOrderList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (stockOutOrderList == null ? "null" : Integer.valueOf(stockOutOrderList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(stockOutOrderList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (StockOutOrder stockOutOrder : stockOutOrderList) {
            stockOutOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(stockOutOrderList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + stockOutOrderList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + stockOutOrderList.size()));
        return result;
    }

    public StockOutOrder getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        StockOutOrder stockOutOrder = null;
        if (id == null) {
            return stockOutOrder;
        }
        try {
            stockOutOrder = (StockOutOrder)this.dao.get(StockOutOrder.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return stockOutOrder;
    }

    public List<StockOutOrder> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List stockOutOrder = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<StockOutOrder>();
        }
        try {
            stockOutOrder = this.dao.getList(StockOutOrder.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (stockOutOrder == null ? "null" : Integer.valueOf(stockOutOrder.size()))));
        return stockOutOrder;
    }

    public Long getStockOutOrderIdByPurchaseNo(String purchaseNo) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by purchaseNo  : " + purchaseNo));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getStockOutOrderIdByPurchaseNo", new Object[]{purchaseNo});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by purchaseNo  : " + purchaseNo));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getStockOutOrderIdsByMerchantId(Long merchantId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by merchantId,start,limit  : " + merchantId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStockOutOrderIdsByMerchantId", new Object[]{merchantId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by merchantId,start,limit)  : " + merchantId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getStockOutOrderIdsByMerchantIdAndStatus(Long merchantId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by merchantId,status,start,limit  : " + merchantId + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStockOutOrderIdsByMerchantIdAndStatus", new Object[]{merchantId, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by merchantId,status,start,limit)  : " + merchantId + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countStockOutOrderIdsByMerchantId(Long merchantId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by merchantId  : " + merchantId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getStockOutOrderIdsByMerchantId", new Object[]{merchantId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by merchantId)  : " + merchantId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countStockOutOrderIdsByMerchantIdAndStatus(Long merchantId, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by merchantId,status  : " + merchantId + " , " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getStockOutOrderIdsByMerchantIdAndStatus", new Object[]{merchantId, status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by merchantId,status)  : " + merchantId + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getStockOutOrderIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStockOutOrderIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countStockOutOrderIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getStockOutOrderIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getStockOutOrderIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

