/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.micro.mall.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.micro.mall.model.StockOrderPrint;
import com.ptteng.micro.mall.service.StockOrderPrintService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StockOrderPrintServiceImpl
extends BaseDaoServiceImpl
implements StockOrderPrintService {
    private static final Log log = LogFactory.getLog(StockOrderPrintServiceImpl.class);

    public Long insert(StockOrderPrint stockOrderPrint) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + stockOrderPrint));
        if (stockOrderPrint == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (stockOrderPrint.getCreateAt() != null) {
            stockOrderPrint.setCreateAt(Long.valueOf(currentTimeMillis));
            stockOrderPrint.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)stockOrderPrint);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + stockOrderPrint));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<StockOrderPrint> insertList(List<StockOrderPrint> stockOrderPrintList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (stockOrderPrintList == null ? "null" : Integer.valueOf(stockOrderPrintList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(stockOrderPrintList)) {
            return new ArrayList<StockOrderPrint>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (StockOrderPrint stockOrderPrint : stockOrderPrintList) {
            stockOrderPrint.setCreateAt(Long.valueOf(currentTimeMillis));
            stockOrderPrint.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(stockOrderPrintList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + stockOrderPrintList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(StockOrderPrint.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(StockOrderPrint stockOrderPrint) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (stockOrderPrint == null ? "null" : stockOrderPrint.getId())));
        boolean result = false;
        if (stockOrderPrint == null) {
            return true;
        }
        stockOrderPrint.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)stockOrderPrint);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + stockOrderPrint));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + stockOrderPrint));
        }
        return result;
    }

    public boolean updateList(List<StockOrderPrint> stockOrderPrintList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (stockOrderPrintList == null ? "null" : Integer.valueOf(stockOrderPrintList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(stockOrderPrintList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (StockOrderPrint stockOrderPrint : stockOrderPrintList) {
            stockOrderPrint.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(stockOrderPrintList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + stockOrderPrintList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + stockOrderPrintList.size()));
        return result;
    }

    public StockOrderPrint getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        StockOrderPrint stockOrderPrint = null;
        if (id == null) {
            return stockOrderPrint;
        }
        try {
            stockOrderPrint = (StockOrderPrint)this.dao.get(StockOrderPrint.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return stockOrderPrint;
    }

    public List<StockOrderPrint> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List stockOrderPrint = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<StockOrderPrint>();
        }
        try {
            stockOrderPrint = this.dao.getList(StockOrderPrint.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (stockOrderPrint == null ? "null" : Integer.valueOf(stockOrderPrint.size()))));
        return stockOrderPrint;
    }

    public List<Long> getStockOrderPrintIdsByMerchantIdAndStatus(Long merchantId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by merchantId,status,start,limit  : " + merchantId + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStockOrderPrintIdsByMerchantIdAndStatus", new Object[]{merchantId, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by merchantId,status,start,limit)  : " + merchantId + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getStockOrderPrintIdsByMerchantId(Long merchantId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by merchantId,start,limit  : " + merchantId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStockOrderPrintIdsByMerchantId", new Object[]{merchantId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by merchantId,start,limit)  : " + merchantId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getStockOrderPrintIdByMerchantIdAndStockOrderIdAndOrderType(Long merchantId, Long stockOrderId, Integer orderType) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by merchantId,stockOrderId,orderType  : " + merchantId + " , " + stockOrderId + " , " + orderType));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getStockOrderPrintIdByMerchantIdAndStockOrderIdAndOrderType", new Object[]{merchantId, stockOrderId, orderType});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by merchantId,stockOrderId,orderType  : " + merchantId + " , " + stockOrderId + " , " + orderType));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getStockOrderPrintIdsByMerchantIdOrderByCreateAt(Long merchantId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by merchantId,start,limit  : " + merchantId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStockOrderPrintIdsByMerchantIdOrderByCreateAt", new Object[]{merchantId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by merchantId,start,limit)  : " + merchantId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countStockOrderPrintIdsByMerchantIdAndStatus(Long merchantId, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by merchantId,status  : " + merchantId + " , " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getStockOrderPrintIdsByMerchantIdAndStatus", new Object[]{merchantId, status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by merchantId,status)  : " + merchantId + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countStockOrderPrintIdsByMerchantId(Long merchantId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by merchantId  : " + merchantId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getStockOrderPrintIdsByMerchantId", new Object[]{merchantId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by merchantId)  : " + merchantId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countStockOrderPrintIdsByMerchantIdOrderByCreateAt(Long merchantId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by merchantId  : " + merchantId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getStockOrderPrintIdsByMerchantIdOrderByCreateAt", new Object[]{merchantId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by merchantId)  : " + merchantId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getStockOrderPrintIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStockOrderPrintIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countStockOrderPrintIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getStockOrderPrintIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getStockOrderPrintIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

