/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.micro.mall.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.micro.mall.model.StockIn;
import com.ptteng.micro.mall.service.StockInService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StockInServiceImpl
extends BaseDaoServiceImpl
implements StockInService {
    private static final Log log = LogFactory.getLog(StockInServiceImpl.class);

    public Long insert(StockIn stockIn) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + stockIn));
        if (stockIn == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        stockIn.setCreateAt(Long.valueOf(currentTimeMillis));
        stockIn.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)stockIn);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + stockIn));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<StockIn> insertList(List<StockIn> stockInList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (stockInList == null ? "null" : Integer.valueOf(stockInList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(stockInList)) {
            return new ArrayList<StockIn>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (StockIn stockIn : stockInList) {
            stockIn.setCreateAt(Long.valueOf(currentTimeMillis));
            stockIn.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(stockInList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + stockInList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(StockIn.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(StockIn stockIn) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (stockIn == null ? "null" : stockIn.getId())));
        boolean result = false;
        if (stockIn == null) {
            return true;
        }
        stockIn.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)stockIn);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + stockIn));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + stockIn));
        }
        return result;
    }

    public boolean updateList(List<StockIn> stockInList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (stockInList == null ? "null" : Integer.valueOf(stockInList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(stockInList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (StockIn stockIn : stockInList) {
            stockIn.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(stockInList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + stockInList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + stockInList.size()));
        return result;
    }

    public StockIn getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        StockIn stockIn = null;
        if (id == null) {
            return stockIn;
        }
        try {
            stockIn = (StockIn)this.dao.get(StockIn.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return stockIn;
    }

    public List<StockIn> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List stockIn = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<StockIn>();
        }
        try {
            stockIn = this.dao.getList(StockIn.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (stockIn == null ? "null" : Integer.valueOf(stockIn.size()))));
        return stockIn;
    }

    public List<Long> getStockInIdsBySkuId(Long skuId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by skuId,start,limit  : " + skuId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStockInIdsBySkuId", new Object[]{skuId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by skuId,start,limit)  : " + skuId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getStockInIdsBySpuId(Long spuId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by spuId,start,limit  : " + spuId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStockInIdsBySpuId", new Object[]{spuId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by spuId,start,limit)  : " + spuId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countStockInIdsBySkuId(Long skuId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by skuId  : " + skuId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getStockInIdsBySkuId", new Object[]{skuId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by skuId)  : " + skuId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countStockInIdsBySpuId(Long spuId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by spuId  : " + spuId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getStockInIdsBySpuId", new Object[]{spuId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by spuId)  : " + spuId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getStockInIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStockInIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countStockInIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getStockInIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getStockInIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

