/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.micro.mall.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.micro.mall.model.StockInOrder;
import com.ptteng.micro.mall.service.StockInOrderService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StockInOrderServiceImpl
extends BaseDaoServiceImpl
implements StockInOrderService {
    private static final Log log = LogFactory.getLog(StockInOrderServiceImpl.class);

    public Long insert(StockInOrder stockInOrder) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + stockInOrder));
        if (stockInOrder == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        stockInOrder.setCreateAt(Long.valueOf(currentTimeMillis));
        stockInOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)stockInOrder);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + stockInOrder));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<StockInOrder> insertList(List<StockInOrder> stockInOrderList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (stockInOrderList == null ? "null" : Integer.valueOf(stockInOrderList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(stockInOrderList)) {
            return new ArrayList<StockInOrder>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (StockInOrder stockInOrder : stockInOrderList) {
            stockInOrder.setCreateAt(Long.valueOf(currentTimeMillis));
            stockInOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(stockInOrderList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + stockInOrderList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(StockInOrder.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(StockInOrder stockInOrder) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (stockInOrder == null ? "null" : stockInOrder.getId())));
        boolean result = false;
        if (stockInOrder == null) {
            return true;
        }
        stockInOrder.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)stockInOrder);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + stockInOrder));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + stockInOrder));
        }
        return result;
    }

    public boolean updateList(List<StockInOrder> stockInOrderList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (stockInOrderList == null ? "null" : Integer.valueOf(stockInOrderList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(stockInOrderList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (StockInOrder stockInOrder : stockInOrderList) {
            stockInOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(stockInOrderList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + stockInOrderList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + stockInOrderList.size()));
        return result;
    }

    public StockInOrder getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        StockInOrder stockInOrder = null;
        if (id == null) {
            return stockInOrder;
        }
        try {
            stockInOrder = (StockInOrder)this.dao.get(StockInOrder.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return stockInOrder;
    }

    public List<StockInOrder> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List stockInOrder = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<StockInOrder>();
        }
        try {
            stockInOrder = this.dao.getList(StockInOrder.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (stockInOrder == null ? "null" : Integer.valueOf(stockInOrder.size()))));
        return stockInOrder;
    }

    public List<Long> getStockInOrderIdsByMerchantIdAndStatus(Long merchantId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by merchantId,status,start,limit  : " + merchantId + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStockInOrderIdsByMerchantIdAndStatus", new Object[]{merchantId, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by merchantId,status,start,limit)  : " + merchantId + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getStockInOrderIdsByMerchantId(Long merchantId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by merchantId,start,limit  : " + merchantId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStockInOrderIdsByMerchantId", new Object[]{merchantId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by merchantId,start,limit)  : " + merchantId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getStockInOrderIdByPurchaseNo(String purchaseNo) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by purchaseNo  : " + purchaseNo));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getStockInOrderIdByPurchaseNo", new Object[]{purchaseNo});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by purchaseNo  : " + purchaseNo));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Integer countStockInOrderIdsByMerchantIdAndStatus(Long merchantId, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by merchantId,status  : " + merchantId + " , " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getStockInOrderIdsByMerchantIdAndStatus", new Object[]{merchantId, status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by merchantId,status)  : " + merchantId + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countStockInOrderIdsByMerchantId(Long merchantId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by merchantId  : " + merchantId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getStockInOrderIdsByMerchantId", new Object[]{merchantId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by merchantId)  : " + merchantId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getStockInOrderIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStockInOrderIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countStockInOrderIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getStockInOrderIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getStockInOrderIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

