/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.micro.mall.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.micro.mall.model.SpuInfo;
import com.ptteng.micro.mall.service.SpuInfoService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SpuInfoServiceImpl
extends BaseDaoServiceImpl
implements SpuInfoService {
    private static final Log log = LogFactory.getLog(SpuInfoServiceImpl.class);

    public Long insert(SpuInfo spuInfo) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + spuInfo));
        if (spuInfo == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        spuInfo.setCreateAt(Long.valueOf(currentTimeMillis));
        spuInfo.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)spuInfo);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + spuInfo));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<SpuInfo> insertList(List<SpuInfo> spuInfoList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (spuInfoList == null ? "null" : Integer.valueOf(spuInfoList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(spuInfoList)) {
            return new ArrayList<SpuInfo>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (SpuInfo spuInfo : spuInfoList) {
            spuInfo.setCreateAt(Long.valueOf(currentTimeMillis));
            spuInfo.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(spuInfoList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + spuInfoList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(SpuInfo.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(SpuInfo spuInfo) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (spuInfo == null ? "null" : spuInfo.getId())));
        boolean result = false;
        if (spuInfo == null) {
            return true;
        }
        spuInfo.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)spuInfo);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + spuInfo));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + spuInfo));
        }
        return result;
    }

    public boolean updateList(List<SpuInfo> spuInfoList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (spuInfoList == null ? "null" : Integer.valueOf(spuInfoList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(spuInfoList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (SpuInfo spuInfo : spuInfoList) {
            spuInfo.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(spuInfoList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + spuInfoList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + spuInfoList.size()));
        return result;
    }

    public SpuInfo getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        SpuInfo spuInfo = null;
        if (id == null) {
            return spuInfo;
        }
        try {
            spuInfo = (SpuInfo)this.dao.get(SpuInfo.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return spuInfo;
    }

    public List<SpuInfo> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List spuInfo = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<SpuInfo>();
        }
        try {
            spuInfo = this.dao.getList(SpuInfo.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (spuInfo == null ? "null" : Integer.valueOf(spuInfo.size()))));
        return spuInfo;
    }

    public Long getSpuInfoIdBySpuId(Long spuId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by spuId  : " + spuId));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getSpuInfoIdBySpuId", new Object[]{spuId});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by spuId  : " + spuId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getSpuInfoIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getSpuInfoIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countSpuInfoIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getSpuInfoIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getSpuInfoIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

