/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.micro.mall.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.micro.mall.model.Sku;
import com.ptteng.micro.mall.service.SkuService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SkuServiceImpl
extends BaseDaoServiceImpl
implements SkuService {
    private static final Log log = LogFactory.getLog(SkuServiceImpl.class);

    public Long insert(Sku sku) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + sku));
        if (sku == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        sku.setCreateAt(Long.valueOf(currentTimeMillis));
        sku.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)sku);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + sku));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Sku> insertList(List<Sku> skuList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (skuList == null ? "null" : Integer.valueOf(skuList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(skuList)) {
            return new ArrayList<Sku>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Sku sku : skuList) {
            sku.setCreateAt(Long.valueOf(currentTimeMillis));
            sku.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(skuList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + skuList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Sku.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Sku sku) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (sku == null ? "null" : sku.getId())));
        boolean result = false;
        if (sku == null) {
            return true;
        }
        sku.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)sku);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + sku));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + sku));
        }
        return result;
    }

    public boolean updateList(List<Sku> skuList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (skuList == null ? "null" : Integer.valueOf(skuList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(skuList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Sku sku : skuList) {
            sku.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(skuList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + skuList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + skuList.size()));
        return result;
    }

    public Sku getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Sku sku = null;
        if (id == null) {
            return sku;
        }
        try {
            sku = (Sku)this.dao.get(Sku.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return sku;
    }

    public List<Sku> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List sku = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Sku>();
        }
        try {
            sku = this.dao.getList(Sku.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (sku == null ? "null" : Integer.valueOf(sku.size()))));
        return sku;
    }

    public List<Long> getSkuIdsByMerchantId(Long merchantId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by merchantId,start,limit  : " + merchantId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getSkuIdsByMerchantId", new Object[]{merchantId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by merchantId,start,limit)  : " + merchantId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getSkuIdsBySpuIdAndStatus(Long spuId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by spuId,status,start,limit  : " + spuId + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getSkuIdsBySpuIdAndStatus", new Object[]{spuId, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by spuId,status,start,limit)  : " + spuId + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countSkuIdsByMerchantId(Long merchantId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by merchantId  : " + merchantId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getSkuIdsByMerchantId", new Object[]{merchantId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by merchantId)  : " + merchantId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countSkuIdsBySpuIdAndStatus(Long spuId, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by spuId,status  : " + spuId + " , " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getSkuIdsBySpuIdAndStatus", new Object[]{spuId, status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by spuId,status)  : " + spuId + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getSkuIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getSkuIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countSkuIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getSkuIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getSkuIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

