/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.micro.mall.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.micro.mall.model.Property;
import com.ptteng.micro.mall.service.PropertyService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyServiceImpl
extends BaseDaoServiceImpl
implements PropertyService {
    private static final Log log = LogFactory.getLog(PropertyServiceImpl.class);

    public Long insert(Property property) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + property));
        if (property == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        property.setCreateAt(Long.valueOf(currentTimeMillis));
        property.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)property);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + property));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Property> insertList(List<Property> propertyList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (propertyList == null ? "null" : Integer.valueOf(propertyList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(propertyList)) {
            return new ArrayList<Property>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Property property : propertyList) {
            property.setCreateAt(Long.valueOf(currentTimeMillis));
            property.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(propertyList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + propertyList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Property.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Property property) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (property == null ? "null" : property.getId())));
        boolean result = false;
        if (property == null) {
            return true;
        }
        property.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)property);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + property));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + property));
        }
        return result;
    }

    public boolean updateList(List<Property> propertyList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (propertyList == null ? "null" : Integer.valueOf(propertyList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(propertyList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Property property : propertyList) {
            property.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(propertyList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + propertyList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + propertyList.size()));
        return result;
    }

    public Property getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Property property = null;
        if (id == null) {
            return property;
        }
        try {
            property = (Property)this.dao.get(Property.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return property;
    }

    public List<Property> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List property = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Property>();
        }
        try {
            property = this.dao.getList(Property.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (property == null ? "null" : Integer.valueOf(property.size()))));
        return property;
    }

    public List<Long> getPropertyIdsByClassifyIdAndStatus(Long classifyId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by classifyId,status,start,limit  : " + classifyId + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getPropertyIdsByClassifyIdAndStatus", new Object[]{classifyId, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by classifyId,status,start,limit)  : " + classifyId + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countPropertyIdsByClassifyIdAndStatus(Long classifyId, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by classifyId,status  : " + classifyId + " , " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getPropertyIdsByClassifyIdAndStatus", new Object[]{classifyId, status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by classifyId,status)  : " + classifyId + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getPropertyIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getPropertyIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countPropertyIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getPropertyIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getPropertyIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

