/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.micro.mall.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.micro.mall.model.PropertyItem;
import com.ptteng.micro.mall.service.PropertyItemService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyItemServiceImpl
extends BaseDaoServiceImpl
implements PropertyItemService {
    private static final Log log = LogFactory.getLog(PropertyItemServiceImpl.class);

    public Long insert(PropertyItem propertyItem) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + propertyItem));
        if (propertyItem == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        propertyItem.setCreateAt(Long.valueOf(currentTimeMillis));
        propertyItem.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)propertyItem);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + propertyItem));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<PropertyItem> insertList(List<PropertyItem> propertyItemList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (propertyItemList == null ? "null" : Integer.valueOf(propertyItemList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(propertyItemList)) {
            return new ArrayList<PropertyItem>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (PropertyItem propertyItem : propertyItemList) {
            propertyItem.setCreateAt(Long.valueOf(currentTimeMillis));
            propertyItem.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(propertyItemList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + propertyItemList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(PropertyItem.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(PropertyItem propertyItem) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (propertyItem == null ? "null" : propertyItem.getId())));
        boolean result = false;
        if (propertyItem == null) {
            return true;
        }
        propertyItem.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)propertyItem);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + propertyItem));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + propertyItem));
        }
        return result;
    }

    public boolean updateList(List<PropertyItem> propertyItemList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (propertyItemList == null ? "null" : Integer.valueOf(propertyItemList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(propertyItemList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (PropertyItem propertyItem : propertyItemList) {
            propertyItem.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(propertyItemList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + propertyItemList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + propertyItemList.size()));
        return result;
    }

    public PropertyItem getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        PropertyItem propertyItem = null;
        if (id == null) {
            return propertyItem;
        }
        try {
            propertyItem = (PropertyItem)this.dao.get(PropertyItem.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return propertyItem;
    }

    public List<PropertyItem> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List propertyItem = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<PropertyItem>();
        }
        try {
            propertyItem = this.dao.getList(PropertyItem.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (propertyItem == null ? "null" : Integer.valueOf(propertyItem.size()))));
        return propertyItem;
    }

    public List<Long> getPropertyItemIdsByPropertyIdAndStatusAndTitle(Long propertyId, Integer status, String title, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by propertyId,status,title,start,limit  : " + propertyId + " , " + status + " , " + title + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getPropertyItemIdsByPropertyIdAndStatusAndTitle", new Object[]{propertyId, status, title}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by propertyId,status,title,start,limit)  : " + propertyId + " , " + status + " , " + title + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getPropertyItemIdsByPropertyIdAndStatus(Long propertyId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by propertyId,status,start,limit  : " + propertyId + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getPropertyItemIdsByPropertyIdAndStatus", new Object[]{propertyId, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by propertyId,status,start,limit)  : " + propertyId + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countPropertyItemIdsByPropertyIdAndStatusAndTitle(Long propertyId, Integer status, String title) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by propertyId,status,title  : " + propertyId + " , " + status + " , " + title));
        }
        Integer count = null;
        try {
            count = this.dao.count("getPropertyItemIdsByPropertyIdAndStatusAndTitle", new Object[]{propertyId, status, title});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by propertyId,status,title)  : " + propertyId + " , " + status + " , " + title));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countPropertyItemIdsByPropertyIdAndStatus(Long propertyId, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by propertyId,status  : " + propertyId + " , " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getPropertyItemIdsByPropertyIdAndStatus", new Object[]{propertyId, status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by propertyId,status)  : " + propertyId + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getPropertyItemIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getPropertyItemIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countPropertyItemIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getPropertyItemIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getPropertyItemIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

