/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.micro.mall.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.micro.mall.model.Customer;
import com.ptteng.micro.mall.service.CustomerService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CustomerServiceImpl
extends BaseDaoServiceImpl
implements CustomerService {
    private static final Log log = LogFactory.getLog(CustomerServiceImpl.class);

    public Long insert(Customer customer) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + customer));
        if (customer == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        customer.setCreateAt(Long.valueOf(currentTimeMillis));
        customer.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)customer);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + customer));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Customer> insertList(List<Customer> customerList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (customerList == null ? "null" : Integer.valueOf(customerList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(customerList)) {
            return new ArrayList<Customer>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Customer customer : customerList) {
            customer.setCreateAt(Long.valueOf(currentTimeMillis));
            customer.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(customerList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + customerList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Customer.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Customer customer) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (customer == null ? "null" : customer.getId())));
        boolean result = false;
        if (customer == null) {
            return true;
        }
        customer.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)customer);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + customer));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + customer));
        }
        return result;
    }

    public boolean updateList(List<Customer> customerList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (customerList == null ? "null" : Integer.valueOf(customerList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(customerList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Customer customer : customerList) {
            customer.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(customerList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + customerList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + customerList.size()));
        return result;
    }

    public Customer getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Customer customer = null;
        if (id == null) {
            return customer;
        }
        try {
            customer = (Customer)this.dao.get(Customer.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return customer;
    }

    public List<Customer> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List customer = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Customer>();
        }
        try {
            customer = this.dao.getList(Customer.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (customer == null ? "null" : Integer.valueOf(customer.size()))));
        return customer;
    }

    public List<Long> getCustomerIdsByMerchantIdAndType(Long merchantId, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by merchantId,type,start,limit  : " + merchantId + " , " + type + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCustomerIdsByMerchantIdAndType", new Object[]{merchantId, type}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by merchantId,type,start,limit)  : " + merchantId + " , " + type + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getCustomerIdsByMerchantId(Long merchantId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by merchantId,start,limit  : " + merchantId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCustomerIdsByMerchantId", new Object[]{merchantId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by merchantId,start,limit)  : " + merchantId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getCustomerIdsByMerchantIdAndStatus(Long merchantId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by merchantId,status,start,limit  : " + merchantId + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCustomerIdsByMerchantIdAndStatus", new Object[]{merchantId, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by merchantId,status,start,limit)  : " + merchantId + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countCustomerIdsByMerchantIdAndType(Long merchantId, Integer type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by merchantId,type  : " + merchantId + " , " + type));
        }
        Integer count = null;
        try {
            count = this.dao.count("getCustomerIdsByMerchantIdAndType", new Object[]{merchantId, type});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by merchantId,type)  : " + merchantId + " , " + type));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countCustomerIdsByMerchantId(Long merchantId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by merchantId  : " + merchantId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getCustomerIdsByMerchantId", new Object[]{merchantId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by merchantId)  : " + merchantId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countCustomerIdsByMerchantIdAndStatus(Long merchantId, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by merchantId,status  : " + merchantId + " , " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getCustomerIdsByMerchantIdAndStatus", new Object[]{merchantId, status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by merchantId,status)  : " + merchantId + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getCustomerIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCustomerIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countCustomerIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getCustomerIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getCustomerIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

