/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.micro.mall.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.micro.mall.model.Cart;
import com.ptteng.micro.mall.service.CartService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CartServiceImpl
extends BaseDaoServiceImpl
implements CartService {
    private static final Log log = LogFactory.getLog(CartServiceImpl.class);

    public Long insert(Cart cart) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + cart));
        if (cart == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        cart.setCreateAt(Long.valueOf(currentTimeMillis));
        cart.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)cart);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + cart));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Cart> insertList(List<Cart> cartList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (cartList == null ? "null" : Integer.valueOf(cartList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(cartList)) {
            return new ArrayList<Cart>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Cart cart : cartList) {
            cart.setCreateAt(Long.valueOf(currentTimeMillis));
            cart.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(cartList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + cartList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Cart.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Cart cart) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (cart == null ? "null" : cart.getId())));
        boolean result = false;
        if (cart == null) {
            return true;
        }
        cart.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)cart);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + cart));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + cart));
        }
        return result;
    }

    public boolean updateList(List<Cart> cartList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (cartList == null ? "null" : Integer.valueOf(cartList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(cartList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Cart cart : cartList) {
            cart.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(cartList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + cartList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + cartList.size()));
        return result;
    }

    public Cart getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Cart cart = null;
        if (id == null) {
            return cart;
        }
        try {
            cart = (Cart)this.dao.get(Cart.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return cart;
    }

    public List<Cart> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List cart = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Cart>();
        }
        try {
            cart = this.dao.getList(Cart.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (cart == null ? "null" : Integer.valueOf(cart.size()))));
        return cart;
    }

    public List<Long> getCartIdsByUserIdAndMerchantId(Long userId, Long merchantId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by userId,merchantId,start,limit  : " + userId + " , " + merchantId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCartIdsByUserIdAndMerchantId", new Object[]{userId, merchantId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by userId,merchantId,start,limit)  : " + userId + " , " + merchantId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countCartIdsByUserIdAndMerchantId(Long userId, Long merchantId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by userId,merchantId  : " + userId + " , " + merchantId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getCartIdsByUserIdAndMerchantId", new Object[]{userId, merchantId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by userId,merchantId)  : " + userId + " , " + merchantId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getCartIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCartIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countCartIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getCartIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getCartIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

