/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.micro.mall.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.micro.mall.model.BaseClassifySpu;
import com.ptteng.micro.mall.service.BaseClassifySpuService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BaseClassifySpuServiceImpl
extends BaseDaoServiceImpl
implements BaseClassifySpuService {
    private static final Log log = LogFactory.getLog(BaseClassifySpuServiceImpl.class);

    public Long insert(BaseClassifySpu baseClassifySpu) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + baseClassifySpu));
        if (baseClassifySpu == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        baseClassifySpu.setCreateAt(Long.valueOf(currentTimeMillis));
        baseClassifySpu.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)baseClassifySpu);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + baseClassifySpu));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<BaseClassifySpu> insertList(List<BaseClassifySpu> baseClassifySpuList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (baseClassifySpuList == null ? "null" : Integer.valueOf(baseClassifySpuList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(baseClassifySpuList)) {
            return new ArrayList<BaseClassifySpu>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (BaseClassifySpu baseClassifySpu : baseClassifySpuList) {
            baseClassifySpu.setCreateAt(Long.valueOf(currentTimeMillis));
            baseClassifySpu.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(baseClassifySpuList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + baseClassifySpuList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(BaseClassifySpu.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(BaseClassifySpu baseClassifySpu) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (baseClassifySpu == null ? "null" : baseClassifySpu.getId())));
        boolean result = false;
        if (baseClassifySpu == null) {
            return true;
        }
        baseClassifySpu.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)baseClassifySpu);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + baseClassifySpu));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + baseClassifySpu));
        }
        return result;
    }

    public boolean updateList(List<BaseClassifySpu> baseClassifySpuList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (baseClassifySpuList == null ? "null" : Integer.valueOf(baseClassifySpuList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(baseClassifySpuList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (BaseClassifySpu baseClassifySpu : baseClassifySpuList) {
            baseClassifySpu.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(baseClassifySpuList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + baseClassifySpuList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + baseClassifySpuList.size()));
        return result;
    }

    public BaseClassifySpu getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        BaseClassifySpu baseClassifySpu = null;
        if (id == null) {
            return baseClassifySpu;
        }
        try {
            baseClassifySpu = (BaseClassifySpu)this.dao.get(BaseClassifySpu.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return baseClassifySpu;
    }

    public List<BaseClassifySpu> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List baseClassifySpu = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<BaseClassifySpu>();
        }
        try {
            baseClassifySpu = this.dao.getList(BaseClassifySpu.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (baseClassifySpu == null ? "null" : Integer.valueOf(baseClassifySpu.size()))));
        return baseClassifySpu;
    }

    public List<Long> getBaseClassifySpuIdsBySpuId(Long spuId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by spuId,start,limit  : " + spuId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getBaseClassifySpuIdsBySpuId", new Object[]{spuId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by spuId,start,limit)  : " + spuId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getBaseClassifySpuIdsByClassifyId(Long classifyId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by classifyId,start,limit  : " + classifyId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getBaseClassifySpuIdsByClassifyId", new Object[]{classifyId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by classifyId,start,limit)  : " + classifyId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getBaseClassifySpuIdsByClassifyIdAndMerchantId(Long classifyId, Long merchantId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by classifyId,merchantId,start,limit  : " + classifyId + " , " + merchantId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getBaseClassifySpuIdsByClassifyIdAndMerchantId", new Object[]{classifyId, merchantId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by classifyId,merchantId,start,limit)  : " + classifyId + " , " + merchantId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countBaseClassifySpuIdsBySpuId(Long spuId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by spuId  : " + spuId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getBaseClassifySpuIdsBySpuId", new Object[]{spuId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by spuId)  : " + spuId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countBaseClassifySpuIdsByClassifyId(Long classifyId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by classifyId  : " + classifyId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getBaseClassifySpuIdsByClassifyId", new Object[]{classifyId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by classifyId)  : " + classifyId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countBaseClassifySpuIdsByClassifyIdAndMerchantId(Long classifyId, Long merchantId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by classifyId,merchantId  : " + classifyId + " , " + merchantId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getBaseClassifySpuIdsByClassifyIdAndMerchantId", new Object[]{classifyId, merchantId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by classifyId,merchantId)  : " + classifyId + " , " + merchantId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getBaseClassifySpuIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getBaseClassifySpuIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countBaseClassifySpuIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getBaseClassifySpuIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getBaseClassifySpuIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

