/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.micro.mall.pojo;

import com.gemantic.common.util.json.GsonUtil;
import com.ptteng.micro.mall.model.Coupon;
import com.ptteng.micro.mall.pojo.DiscountInfoDTO;
import com.ptteng.micro.mall.pojo.PromotionItemVO;
import com.ptteng.micro.mall.pojo.PromotionVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class DiscountDetailDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long discountId;
    private String discountName;
    private Integer type;
    private Integer discountType;
    private Integer discountCategory;
    private Integer applicableType;
    private List<Long> skuIds = new ArrayList<Long>();
    private List<Long> spuIds = new ArrayList<Long>();
    private List<Long> hitSkuIds = new ArrayList<Long>();
    private BigDecimal thresholdAmount;
    private BigDecimal discount;
    private BigDecimal discountAmount;
    private BigDecimal finalDiscountAmount;
    private BigDecimal calculationAmount;
    private List<DiscountItem> items = new ArrayList<DiscountItem>();
    private List<DiscountItem> finalItems = new ArrayList<DiscountItem>();
    private List<PromotionItemVO> hitPromotionItemList = new ArrayList<PromotionItemVO>();
    private PromotionVO promotionVO;
    private Coupon coupon;

    public DiscountDetailDTO() {
    }

    public DiscountDetailDTO(Long discountId, String discountName, Integer type, Integer discountType, Integer discountCategory, Integer applicableType) {
        this.discountId = discountId;
        this.discountName = discountName;
        this.type = type;
        this.discountType = discountType;
        this.discountCategory = discountCategory;
        this.applicableType = applicableType;
        this.skuIds = new ArrayList<Long>();
        this.spuIds = new ArrayList<Long>();
        this.hitSkuIds = new ArrayList<Long>();
        this.thresholdAmount = BigDecimal.ZERO;
        this.discountAmount = BigDecimal.ZERO;
        this.discount = BigDecimal.ZERO;
        this.finalDiscountAmount = BigDecimal.ZERO;
        this.calculationAmount = BigDecimal.ZERO;
        this.items = new ArrayList<DiscountItem>();
    }

    public List<Long> getSkuIds() {
        return this.skuIds;
    }

    public BigDecimal getThresholdAmount() {
        return this.thresholdAmount;
    }

    public void setThresholdAmount(BigDecimal thresholdAmount) {
        this.thresholdAmount = thresholdAmount;
    }

    public void setSkuIds(List<Long> skuIds) {
        this.skuIds = skuIds;
    }

    public List<Long> getSpuIds() {
        return this.spuIds;
    }

    public void setSpuIds(List<Long> spuIds) {
        this.spuIds = spuIds;
    }

    public Long getDiscountId() {
        return this.discountId;
    }

    public void setDiscountId(Long discountId) {
        this.discountId = discountId;
    }

    public String getDiscountName() {
        return this.discountName;
    }

    public void setDiscountName(String discountName) {
        this.discountName = discountName;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getDiscountType() {
        return this.discountType;
    }

    public void setDiscountType(Integer discountType) {
        this.discountType = discountType;
    }

    public Integer getDiscountCategory() {
        return this.discountCategory;
    }

    public void setDiscountCategory(Integer discountCategory) {
        this.discountCategory = discountCategory;
    }

    public Integer getApplicableType() {
        return this.applicableType;
    }

    public void setApplicableType(Integer applicableType) {
        this.applicableType = applicableType;
    }

    public BigDecimal getDiscountAmount() {
        return this.discountAmount;
    }

    public void setDiscountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
    }

    public BigDecimal getCalculationAmount() {
        return this.calculationAmount;
    }

    public void setCalculationAmount(BigDecimal calculationAmount) {
        this.calculationAmount = calculationAmount;
    }

    public List<DiscountItem> getItems() {
        return this.items;
    }

    public void setItems(List<DiscountItem> items) {
        this.items = items;
    }

    public List<Long> getHitSkuIds() {
        return this.hitSkuIds;
    }

    public void setHitSkuIds(List<Long> hitSkuIds) {
        this.hitSkuIds = hitSkuIds;
    }

    public BigDecimal getFinalDiscountAmount() {
        return this.finalDiscountAmount;
    }

    public void setFinalDiscountAmount(BigDecimal finalDiscountAmount) {
        this.finalDiscountAmount = finalDiscountAmount;
    }

    public BigDecimal getDiscount() {
        return this.discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    public List<PromotionItemVO> getHitPromotionItemList() {
        return this.hitPromotionItemList;
    }

    public void setHitPromotionItemList(List<PromotionItemVO> hitPromotionItemList) {
        this.hitPromotionItemList = hitPromotionItemList;
    }

    public List<DiscountItem> getFinalItems() {
        return this.finalItems;
    }

    public void setFinalItems(List<DiscountItem> finalItems) {
        this.finalItems = finalItems;
    }

    public PromotionVO getPromotionVO() {
        return this.promotionVO;
    }

    public void setPromotionVO(PromotionVO promotionVO) {
        this.promotionVO = promotionVO;
    }

    public Coupon getCoupon() {
        return this.coupon;
    }

    public void setCoupon(Coupon coupon) {
        this.coupon = coupon;
    }

    public static List<DiscountInfoDTO> toDiscountInfoDTOList(List<DiscountDetailDTO> discountDetailDTOList) {
        ArrayList<DiscountInfoDTO> discountInfoDTOList = new ArrayList<DiscountInfoDTO>();
        for (DiscountDetailDTO discountDetailDTO : discountDetailDTOList) {
            for (DiscountItem item : discountDetailDTO.getItems()) {
                DiscountInfoDTO discountInfoDTO = new DiscountInfoDTO();
                discountInfoDTO.setSaleId(discountDetailDTO.getDiscountId());
                discountInfoDTO.setType(discountDetailDTO.getType());
                discountInfoDTO.setDiscount(item.getDiscountAmount());
                discountInfoDTO.setPayAmount(item.getActualPayAmount());
                discountInfoDTO.setSkuId(item.getSkuId());
                discountInfoDTO.setSaleAmount(discountDetailDTO.getDiscount());
                discountInfoDTOList.add(discountInfoDTO);
            }
        }
        return discountInfoDTOList;
    }

    public String toString() {
        return "DiscountDetailDTO{discountCategory=" + this.discountCategory + ", discountId=" + this.discountId + ", discountName='" + this.discountName + '\'' + ", type=" + this.type + ", discountType=" + this.discountType + ", applicableType=" + this.applicableType + ", hitSkuIds=" + this.hitSkuIds + ", thresholdAmount=" + this.thresholdAmount + ", discount=" + this.discount + ", discountAmount=" + this.discountAmount + ", finalDiscountAmount=" + this.finalDiscountAmount + ", calculationAmount=" + this.calculationAmount + ", items=" + GsonUtil.toJson(this.items) + ", finalItems=" + GsonUtil.toJson(this.finalItems) + ", hitPromotionItemList=" + GsonUtil.toJson(this.hitPromotionItemList) + ", promotionVO=" + GsonUtil.toJson((Object)this.promotionVO) + ", coupon=" + GsonUtil.toJson((Object)this.coupon) + '}';
    }

    public static class DiscountItem
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long skuId;
        private Long spuId;
        private BigDecimal originalPrice;
        private Integer cnt;
        private BigDecimal discountAmount;
        private BigDecimal rateDiscountAmount;
        private BigDecimal totalAmount;
        private int exchange;
        private BigDecimal discountRate;
        private BigDecimal actualPayAmount;

        public DiscountItem() {
            this.originalPrice = BigDecimal.ZERO;
            this.cnt = 0;
            this.discountAmount = BigDecimal.ZERO;
            this.totalAmount = this.originalPrice.multiply(BigDecimal.valueOf(this.cnt.intValue()));
            this.exchange = 0;
            this.discountRate = BigDecimal.ZERO;
            this.rateDiscountAmount = BigDecimal.ZERO;
            this.actualPayAmount = this.totalAmount;
        }

        public DiscountItem(Long skuId, Long spuId, BigDecimal originalPrice, Integer cnt) {
            this.skuId = skuId;
            this.spuId = spuId;
            this.originalPrice = originalPrice;
            this.cnt = cnt;
            this.discountAmount = BigDecimal.ZERO;
            this.totalAmount = originalPrice.multiply(BigDecimal.valueOf(cnt.intValue()));
            this.exchange = 0;
            this.discountRate = BigDecimal.ZERO;
            this.rateDiscountAmount = BigDecimal.ZERO;
            this.actualPayAmount = this.totalAmount;
        }

        public Long getSkuId() {
            return this.skuId;
        }

        public void setSkuId(Long skuId) {
            this.skuId = skuId;
        }

        public Long getSpuId() {
            return this.spuId;
        }

        public void setSpuId(Long spuId) {
            this.spuId = spuId;
        }

        public BigDecimal getOriginalPrice() {
            return this.originalPrice;
        }

        public void setOriginalPrice(BigDecimal originalPrice) {
            this.originalPrice = originalPrice;
        }

        public Integer getCnt() {
            return this.cnt;
        }

        public void setCnt(Integer cnt) {
            this.cnt = cnt;
        }

        public BigDecimal getDiscountAmount() {
            return this.discountAmount;
        }

        public void setDiscountAmount(BigDecimal discountAmount) {
            this.discountAmount = discountAmount;
        }

        public BigDecimal getTotalAmount() {
            return this.totalAmount;
        }

        public void setTotalAmount(BigDecimal totalAmount) {
            this.totalAmount = totalAmount;
        }

        public int getExchange() {
            return this.exchange;
        }

        public void setExchange(int exchange) {
            this.exchange = exchange;
        }

        public BigDecimal getDiscountRate() {
            return this.discountRate;
        }

        public void setDiscountRate(BigDecimal discountRate) {
            this.discountRate = discountRate;
        }

        public BigDecimal getRateDiscountAmount() {
            return this.rateDiscountAmount;
        }

        public void setRateDiscountAmount(BigDecimal rateDiscountAmount) {
            this.rateDiscountAmount = rateDiscountAmount;
        }

        public BigDecimal getActualPayAmount() {
            return this.actualPayAmount;
        }

        public void setActualPayAmount(BigDecimal actualPayAmount) {
            this.actualPayAmount = actualPayAmount;
        }

        public DiscountItem clone() {
            try {
                DiscountItem clone = (DiscountItem)super.clone();
                if (this.originalPrice != null) {
                    clone.originalPrice = new BigDecimal(this.originalPrice.toString());
                }
                if (this.discountAmount != null) {
                    clone.discountAmount = new BigDecimal(this.discountAmount.toString());
                }
                if (this.rateDiscountAmount != null) {
                    clone.rateDiscountAmount = new BigDecimal(this.rateDiscountAmount.toString());
                }
                if (this.totalAmount != null) {
                    clone.totalAmount = new BigDecimal(this.totalAmount.toString());
                }
                if (this.discountRate != null) {
                    clone.discountRate = new BigDecimal(this.discountRate.toString());
                }
                if (this.actualPayAmount != null) {
                    clone.actualPayAmount = new BigDecimal(this.actualPayAmount.toString());
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("\u514b\u9686DiscountItem\u5931\u8d25", e);
            }
        }

        public String toString() {
            return "DiscountItem{skuId=" + this.skuId + ", spuId=" + this.spuId + ", originalPrice=" + this.originalPrice + ", cnt=" + this.cnt + ", discountAmount=" + this.discountAmount + ", rateDiscountAmount=" + this.rateDiscountAmount + ", totalAmount=" + this.totalAmount + ", exchange=" + this.exchange + ", discountRate=" + this.discountRate + ", actualPayAmount=" + this.actualPayAmount + '}';
        }
    }
}

