/**
 *
 */
package com.ptteng.sca.micro.mall.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.micro.mall.model.Worker;
import com.ptteng.micro.mall.service.WorkerService;

import java.util.List;
import java.util.Map;

public class WorkerSCAClient implements WorkerService {

    private WorkerService workerService;

    public WorkerService getWorkerService() {
        return workerService;
    }


    public void setWorkerService(WorkerService workerService) {
        this.workerService = workerService;
    }


    @Override
    public Long insert(Worker worker) throws ServiceException, ServiceDaoException {

        return workerService.insert(worker);


    }


    @Override
    public List<Worker> insertList(List<Worker> workerList) throws ServiceException, ServiceDaoException {

        return workerService.insertList(workerList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return workerService.delete(id);


    }


    @Override
    public boolean update(Worker worker) throws ServiceException, ServiceDaoException {

        return workerService.update(worker);


    }


    @Override
    public boolean updateList(List<Worker> workerList) throws ServiceException, ServiceDaoException {

        return workerService.updateList(workerList);


    }


    @Override
    public Worker getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return workerService.getObjectById(id);


    }


    @Override
    public List<Worker> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return workerService.getObjectsByIds(ids);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getWorkerIdsByMerchantId(Long merchantId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return workerService.getWorkerIdsByMerchantId(merchantId, start, limit);


    }

    @Override
    public Long getWorkerIdByMobile(String mobile) throws ServiceException, ServiceDaoException {
        return workerService.getWorkerIdByMobile(mobile);
    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countWorkerIdsByMerchantId(Long merchantId) throws ServiceException, ServiceDaoException {

        return workerService.countWorkerIdsByMerchantId(merchantId);


    }


    @Override
    public List<Long> getWorkerIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return workerService.getWorkerIds(start, limit);
    }

    @Override
    public Integer countWorkerIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return workerService.countWorkerIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return workerService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return workerService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        workerService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.workerService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getMapListByDynamicCondition(Class clz,
                                               Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.workerService.getMapListByDynamicCondition(clz, conditions, start, limit);
    }


}

