/**
 *
 */
package com.ptteng.sca.micro.mall.client;

import java.util.List;
import java.util.Map;

import com.ptteng.micro.mall.model.Spu;
import com.ptteng.micro.mall.service.SpuService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class SpuSCAClient implements SpuService {

    private SpuService spuService;

    public SpuService getSpuService() {
        return spuService;
    }


    public void setSpuService(SpuService spuService) {
        this.spuService = spuService;
    }


    @Override
    public Long insert(Spu spu) throws ServiceException, ServiceDaoException {

        return spuService.insert(spu);


    }


    @Override
    public List<Spu> insertList(List<Spu> spuList) throws ServiceException, ServiceDaoException {

        return spuService.insertList(spuList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return spuService.delete(id);


    }


    @Override
    public boolean update(Spu spu) throws ServiceException, ServiceDaoException {

        return spuService.update(spu);


    }


    @Override
    public boolean updateList(List<Spu> spuList) throws ServiceException, ServiceDaoException {

        return spuService.updateList(spuList);


    }


    @Override
    public Spu getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return spuService.getObjectById(id);


    }


    @Override
    public List<Spu> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return spuService.getObjectsByIds(ids);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getSpuIdsByMerchantId(Long merchantId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return spuService.getSpuIdsByMerchantId(merchantId, start, limit);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getSpuIdsByMerchantIdAndStatus(Long merchantId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return spuService.getSpuIdsByMerchantIdAndStatus(merchantId, status, start, limit);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countSpuIdsByMerchantId(Long merchantId) throws ServiceException, ServiceDaoException {

        return spuService.countSpuIdsByMerchantId(merchantId);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countSpuIdsByMerchantIdAndStatus(Long merchantId, Integer status) throws ServiceException, ServiceDaoException {

        return spuService.countSpuIdsByMerchantIdAndStatus(merchantId, status);


    }


    @Override
    public List<Long> getSpuIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return spuService.getSpuIds(start, limit);
    }

    @Override
    public Long getSpuIdBySpuSeriesId(Long spuSeriesId) throws ServiceException, ServiceDaoException {
        return spuService.getSpuIdBySpuSeriesId(spuSeriesId);
    }

    @Override
    public Integer countSpuIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return spuService.countSpuIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return spuService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return spuService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        spuService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.spuService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public Object getMapListByDynamicCondition(Class clz,
                                               Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.spuService.getMapListByDynamicCondition(clz, conditions, start, limit);
    }

}

