package com.ptteng.micro.mall.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.micro.mall.model.WorkerOrderRelation;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface WorkerOrderRelationService extends BaseDaoService {


    public Long insert(WorkerOrderRelation workerOrderRelation) throws ServiceException, ServiceDaoException;


    public List<WorkerOrderRelation> insertList(List<WorkerOrderRelation> workerOrderRelationList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(WorkerOrderRelation workerOrderRelation) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<WorkerOrderRelation> workerOrderRelationList) throws ServiceException, ServiceDaoException;


    public WorkerOrderRelation getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<WorkerOrderRelation> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countWorkerOrderRelationIdsByWorkerId(Long workerId) throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getWorkerOrderRelationIdsByOrderId(Long orderId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getWorkerOrderRelationIdsByWorkerId(Long workerId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getWorkerOrderRelationIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countWorkerOrderRelationIds() throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getWorkerOrderRelationIdsByOrderIdAndStatus(Long orderId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getWorkerOrderRelationIdByOrderIdAndWorkerId(Long orderId, Long workerId) throws ServiceException, ServiceDaoException;


}

