package com.ptteng.micro.mall.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.micro.mall.model.StockOutOrder;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface StockOutOrderService extends BaseDaoService {

	



   		   
		
		public Long insert(StockOutOrder stockOutOrder)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<StockOutOrder> insertList(List<StockOutOrder> stockOutOrderList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(StockOutOrder stockOutOrder)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<StockOutOrder> stockOutOrderList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public StockOutOrder getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<StockOutOrder> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countStockOutOrderIdsByMerchantId(Long merchantId)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countStockOutOrderIdsByMerchantIdAndStatus(Long merchantId, Integer status)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getStockOutOrderIdByPurchaseNo(String purchaseNo)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getStockOutOrderIdsByMerchantId(Long merchantId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getStockOutOrderIdsByMerchantIdAndStatus(Long merchantId, Integer status, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getStockOutOrderIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countStockOutOrderIds() throws ServiceException, ServiceDaoException;
	

}

