package com.ptteng.micro.mall.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.micro.mall.model.StockInOrder;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface StockInOrderService extends BaseDaoService {

	



   		   
		
		public Long insert(StockInOrder stockInOrder)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<StockInOrder> insertList(List<StockInOrder> stockInOrderList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(StockInOrder stockInOrder)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<StockInOrder> stockInOrderList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public StockInOrder getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<StockInOrder> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countStockInOrderIdsByMerchantIdAndStatus(Long merchantId, Integer status)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countStockInOrderIdsByMerchantId(Long merchantId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getStockInOrderIdsByMerchantIdAndStatus(Long merchantId, Integer status, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getStockInOrderIdsByMerchantId(Long merchantId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getStockInOrderIdByPurchaseNo(String purchaseNo)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getStockInOrderIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countStockInOrderIds() throws ServiceException, ServiceDaoException;
	

}

