package com.ptteng.micro.mall.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.micro.mall.model.Spu;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface SpuService extends BaseDaoService {


    public Long insert(Spu spu) throws ServiceException, ServiceDaoException;


    public List<Spu> insertList(List<Spu> spuList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(Spu spu) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<Spu> spuList) throws ServiceException, ServiceDaoException;


    public Spu getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<Spu> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countSpuIdsByMerchantId(Long merchantId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countSpuIdsByMerchantIdAndStatus(Long merchantId, Integer status) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getSpuIdsByMerchantId(Long merchantId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getSpuIdsByMerchantIdAndStatus(Long merchantId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getSpuIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getSpuIdBySpuSeriesId(Long spuSeriesId) throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countSpuIds() throws ServiceException, ServiceDaoException;


}

