package com.ptteng.micro.mall.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.micro.mall.model.Sku;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface SkuService extends BaseDaoService {

	



   		   
		
		public Long insert(Sku sku)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Sku> insertList(List<Sku> skuList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Sku sku)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Sku> skuList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Sku getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Sku> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countSkuIdsByMerchantId(Long merchantId)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countSkuIdsBySpuIdAndStatus(Long spuId, Integer status)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getSkuIdsByMerchantId(Long merchantId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getSkuIdsBySpuIdAndStatus(Long spuId, Integer status, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getSkuIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countSkuIds() throws ServiceException, ServiceDaoException;
	

}

