package com.ptteng.micro.mall.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.micro.mall.model.Requirement;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface RequirementService extends BaseDaoService {


    public Long insert(Requirement requirement) throws ServiceException, ServiceDaoException;


    public List<Requirement> insertList(List<Requirement> requirementList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(Requirement requirement) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<Requirement> requirementList) throws ServiceException, ServiceDaoException;


    public Requirement getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<Requirement> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countRequirementIdsByUserIdAndMerchantId(Long userId, Long merchantId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getRequirementIdsByUserIdAndMerchantId(Long userId, Long merchantId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getRequirementIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countRequirementIds() throws ServiceException, ServiceDaoException;


}

