package com.ptteng.micro.mall.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.micro.mall.model.Cart;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface CartService extends BaseDaoService {

	



   		   
		
		public Long insert(Cart cart)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Cart> insertList(List<Cart> cartList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Cart cart)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Cart> cartList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Cart getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Cart> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countCartIdsByUserIdAndMerchantId(Long userId, Long merchantId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getCartIdsByUserIdAndMerchantId(Long userId, Long merchantId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getCartIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countCartIds() throws ServiceException, ServiceDaoException;
	

}

