package com.ptteng.micro.mall.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.micro.mall.model.Campaign;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface CampaignService extends BaseDaoService {


    public Long insert(Campaign campaign) throws ServiceException, ServiceDaoException;


    public List<Campaign> insertList(List<Campaign> campaignList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(Campaign campaign) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<Campaign> campaignList) throws ServiceException, ServiceDaoException;


    public Campaign getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<Campaign> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countCampaignIdsByTypeAndStatus(Integer type, Integer status) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getCampaignIdsByTypeAndStatus(Integer type, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getCampaignIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countCampaignIds() throws ServiceException, ServiceDaoException;


}

