package com.ptteng.micro.mall.service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.micro.mall.model.BoxSkuRelation;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface BoxSkuRelationService extends BaseDaoService {


    public Long insert(BoxSkuRelation boxSkuRelation) throws ServiceException, ServiceDaoException;


    public List<BoxSkuRelation> insertList(List<BoxSkuRelation> boxSkuRelationList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(BoxSkuRelation boxSkuRelation) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<BoxSkuRelation> boxSkuRelationList) throws ServiceException, ServiceDaoException;


    public BoxSkuRelation getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<BoxSkuRelation> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getBoxSkuRelationIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countBoxSkuRelationIds() throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getBoxSkuRelationIdsByBoxId(Long boxId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;

    public List<Long> getRandomBoxSkuRelationIdsByBoxId(Long boxId, Integer count, Integer start, Integer limit) throws ServiceException, ServiceDaoException;

    public List<BoxSkuRelation> getRandomBoxSkuRelationIdsByBoxIdAndOdds(List<BoxSkuRelation> boxSkuRelations ,Long boxId, Integer count, Boolean takeAllFlag) throws ServiceException, ServiceDaoException;


}

