package com.ptteng.micro.mall.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.micro.mall.model.Box;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface BoxService extends BaseDaoService {


    public Long insert(Box box) throws ServiceException, ServiceDaoException;


    public List<Box> insertList(List<Box> boxList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(Box box) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<Box> boxList) throws ServiceException, ServiceDaoException;


    public Box getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<Box> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getBoxIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countBoxIds() throws ServiceException, ServiceDaoException;


}

