package com.ptteng.micro.mall.model;

import com.ptteng.mongo.model.MongoLocation;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;


public class WorkerLocation implements Serializable {


    private static final long serialVersionUID = -6075382254344525365L;
    private Long _id;

    /**
     * 保证金缴纳状态
     */
    private Integer depositStatus;

    /*开工状态*/
    private Integer workStatus;


    /**
     * 实名认证状态
     */
    private Integer verifiedStatus;

    /*
     * 平均评分
     * */
    private Double averageEvaluation;

    private MongoLocation loc;
    private Long updateAt;
    private Long startTime;

    public WorkerLocation() {
        super();
    }

    public WorkerLocation(Long id, MongoLocation loc) {
        super();
        this._id = id;
        this.loc = loc;
    }

    public WorkerLocation(Worker worker, MongoLocation loc) {
        super();
        this._id = worker.getId();
        this.loc = loc;
        this.verifiedStatus = worker.getVerifiedStatus();
        this.depositStatus = worker.getDepositStatus();
        this.workStatus = worker.getWorkStatus();
        this.averageEvaluation = worker.getAverageEvaluation();
        this.updateAt = System.currentTimeMillis();
        this.startTime = worker.getStartTime();
    }


    public Long get_id() {
        return _id;
    }

    public void set_id(Long _id) {
        this._id = _id;
    }


    public MongoLocation getLoc() {
        return loc;
    }

    public void setLoc(MongoLocation loc) {
        this.loc = loc;
    }

    public WorkerLocation(Integer depositStatus, Integer verifiedStatus, Integer workStatus) {
        this.depositStatus = depositStatus;
        this.verifiedStatus = verifiedStatus;
        this.workStatus = workStatus;
    }

    public Integer getDepositStatus() {
        return depositStatus;
    }

    public void setDepositStatus(Integer depositStatus) {
        this.depositStatus = depositStatus;
    }

    public Integer getVerifiedStatus() {
        return verifiedStatus;
    }

    public void setVerifiedStatus(Integer verifiedStatus) {
        this.verifiedStatus = verifiedStatus;
    }


    public Double getAverageEvaluation() {
        return averageEvaluation;
    }

    public void setAverageEvaluation(Double averageEvaluation) {
        this.averageEvaluation = averageEvaluation;
    }

    public Integer getWorkStatus() {
        return workStatus;
    }

    public void setWorkStatus(Integer workStatus) {
        this.workStatus = workStatus;
    }

    public Long getUpdateAt() {
        return updateAt;
    }

    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    public Long getStartTime() {
        return startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}
