package com.ptteng.micro.mall.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "spu")
public class Spu implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 4000168698588295168L;


    /**
     * 下架
     */
    public static final Integer STATUS_OFF = 0;

    /**
     * 上架
     */
    public static final Integer STATUS_ON = 1;

    /**
     * 删除
     */
    public static final Integer STATUS_DEL = -1;
    //新品
    public static final Integer IS_NEW_SPU = 1;
    public static final Integer IS_NOT_NEW_SPU = 0;
    /*商品类型
    * 1默认 2虚拟
    * */
    public static final Integer SPU_TYPE_VIRTUAL = 2;
    public static final Integer SPU_TYPE_DEFAULT = 1;

    /**
     * 自增长ID
     */
    private Long id;

    private Long brandId;
    /**
     * 配图
     */
    private String pic;


    /**
     * 属性名
     */
    private String title;



    /**
     * 状态
     */
    private Integer status;

    private Integer sort;

    /**
     * 销量
     */
    private Integer sales;
    /**
     * 库存
     */
    private Integer stock;


    /**
     * 店铺id
     */
    private Long merchantId;


    /**
     * 展示价格
     */
    private String showPrice;
    /**
     * 展示价格
     */
    private BigDecimal price;


    /**
     * 规格set
     */
    private String proItemSet;


    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 创建人
     */
    private Long createBy;


    /**
     * 更新人
     */
    private Long updateBy;
    /**
     * 分类信息
     */
    private String classifyDesc;
    private Long classifyId;

    private String spuInfo;
    private String slogan;
    private String keyword1;
    private String keyword2;

    /**
     * 编码
     */
    private String code;
    /**
     * 条形码
     */
    private String barCode;

    private String inBulk;
    private Integer isNew;
    private Integer spuType;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "brand_id")
    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    @Column(name = "pic")
    public String getPic() {
        return pic;
    }


    public void setPic(String pic) {
        this.pic = pic;
    }

    @Column(name = "sort")
    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    @Column(name = "title")
    public String getTitle() {
        return title;
    }


    public void setTitle(String title) {
        this.title = title;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "sales")
    public Integer getSales() {
        return sales;
    }


    public void setSales(Integer sales) {
        this.sales = sales;
    }

    @Column(name = "merchant_id")
    public Long getMerchantId() {
        return merchantId;
    }


    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    @Column(name = "show_price")
    public String getShowPrice() {
        return showPrice;
    }


    public void setShowPrice(String showPrice) {
        this.showPrice = showPrice;
    }

    @Column(name = "pro_item_set")
    public String getProItemSet() {
        return proItemSet;
    }


    public void setProItemSet(String proItemSet) {
        this.proItemSet = proItemSet;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Transient
    public String getClassifyDesc() {
        return classifyDesc;
    }

    public void setClassifyDesc(String classifyDesc) {
        this.classifyDesc = classifyDesc;
    }

    @Column(name = "stock")
    public Integer getStock() {
        return stock;
    }

    public void setStock(Integer stock) {
        this.stock = stock;
    }

    @Column(name = "price")
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    @Transient
    public String getSpuInfo() {
        return spuInfo;
    }

    public void setSpuInfo(String spuInfo) {
        this.spuInfo = spuInfo;
    }

    @Column(name = "slogan")
    public String getSlogan() {
        return slogan;
    }

    public void setSlogan(String slogan) {
        this.slogan = slogan;
    }

    @Transient
    public Long getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(Long classifyId) {
        this.classifyId = classifyId;
    }

    @Column(name = "keyword_1")
    public String getKeyword1() {
        return keyword1;
    }

    public void setKeyword1(String keyword1) {
        this.keyword1 = keyword1;
    }

    @Column(name = "keyword_2")
    public String getKeyword2() {
        return keyword2;
    }

    public void setKeyword2(String keyword2) {
        this.keyword2 = keyword2;
    }

    @Column(name = "code")
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Column(name = "bar_code")
    public String getBarCode() {
        return barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    @Column(name = "in_bulk")
    public String getInBulk() {
        return inBulk;
    }

    public void setInBulk(String inBulk) {
        this.inBulk = inBulk;
    }
    @Column(name = "is_new")
    public Integer getIsNew() {
        return isNew;
    }

    public void setIsNew(Integer isNew) {
        this.isNew = isNew;
    }
    @Column(name = "spu_type")
    public Integer getSpuType() {
        return spuType;
    }

    public void setSpuType(Integer spuType) {
        this.spuType = spuType;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

