package com.ptteng.micro.mall.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "campaign")
public class Campaign implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 2441277586247590912L;


    /**
     *
     */
    public static final int STATUS_UP = 1;

    /**
     *
     */
    public static final int STATUS_DOWN = 2;

    public static final int HAS_OPEN_FOR_SALE = 1;
    public static final int NOT_OPEN_FOR_SALE = 2;

    /**
     *
     */
    public static final int TYPE_PRE_SALES = 20;

    /**
     *
     */
    public static final int TYPE_SPOT_GOODS = 10;

    /**
     *
     */
    public static final String STRATEGY_EQUAL_PROBABILITY = "EQUAL";
    public static final String STRATEGY_MANUALLY_SET_WEIGHTS = "MANUALLY";


    /**
     * 自增长ID
     */
    private Long id;
    private Long merchantId;

    /**
     * 系列名称
     */
    private String name;


    /**
     * 系列排序
     */
    private Integer sort;


    /**
     * 箱数
     */
    private Integer boxTotal;


    /**
     * 剩余箱数
     */
    private Integer boxTotalAvailable = 0;
    /**
     * 库存
     */
    private Integer stock = 0;
    private Integer stockPerBox = 0;


    /**
     * 销量
     */
    private Integer sales = 0;

    /**
     * 单价
     */
    private BigDecimal unitPrice;


    /**
     * 状态
     */
    private Integer status = STATUS_DOWN;

    private Integer hasOpenForSale = NOT_OPEN_FOR_SALE;

    /**
     * 系列类型
     */
    private Integer type;


    /**
     * 图片信息
     */
    private String pic1;


    /**
     * 系列首图
     */
    private String pic2;

    private Long classifyId;
    /**
     * 分类信息
     */
    private String classifyDesc;

    private Long specialSkuId;
    /**
     * (购买N次)
     */
    private String config;


    /**
     * 赏品信息
     */
    private String content;


    /**
     * 抽赏策略
     */
    private String strategy;


    /**
     * 备用1
     */
    private String keyword3;


    /**
     * 备用1
     */
    private String keyword4;


    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 创建人
     */
    private Long createBy;


    /**
     * 更新人
     */
    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }
    @Column(name = "merchant_id")
    public Long getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "sort")
    public Integer getSort() {
        return sort;
    }


    public void setSort(Integer sort) {
        this.sort = sort;
    }

    @Column(name = "box_total")
    public Integer getBoxTotal() {
        return boxTotal;
    }


    public void setBoxTotal(Integer boxTotal) {
        this.boxTotal = boxTotal;
    }

    @Column(name = "box_total_available")
    public Integer getBoxTotalAvailable() {
        return boxTotalAvailable;
    }


    public void setBoxTotalAvailable(Integer boxTotalAvailable) {
        this.boxTotalAvailable = boxTotalAvailable;
    }

    @Column(name = "unit_price")
    public BigDecimal getUnitPrice() {
        return unitPrice;
    }


    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "has_open_for_sale")
    public Integer getHasOpenForSale() {
        return hasOpenForSale;
    }

    public void setHasOpenForSale(Integer hasOpenForSale) {
        this.hasOpenForSale = hasOpenForSale;
    }

    @Column(name = "type")
    public Integer getType() {
        return type;
    }


    public void setType(Integer type) {
        this.type = type;
    }

    @Transient
    public Long getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(Long classifyId) {
        this.classifyId = classifyId;
    }

    @Transient
    public String getClassifyDesc() {
        return classifyDesc;
    }

    public void setClassifyDesc(String classifyDesc) {
        this.classifyDesc = classifyDesc;
    }

    @Column(name = "special_sku_id")
    public Long getSpecialSkuId() {
        return specialSkuId;
    }
    public void setSpecialSkuId(Long specialSkuId) {
        this.specialSkuId = specialSkuId;
    }


    @Column(name = "stock")
    public Integer getStock() {
        return stock;
    }


    public void setStock(Integer stock) {
        this.stock = stock;
    }
    @Column(name = "stock_per_box")
    public Integer getStockPerBox() {
        return stockPerBox;
    }

    public void setStockPerBox(Integer stockPerBox) {
        this.stockPerBox = stockPerBox;
    }

    @Column(name = "sales")
    public Integer getSales() {
        return sales;
    }

    public void setSales(Integer sales) {
        this.sales = sales;
    }

    @Column(name = "pic_1")
    public String getPic1() {
        return pic1;
    }


    public void setPic1(String pic1) {
        this.pic1 = pic1;
    }

    @Column(name = "pic_2")
    public String getPic2() {
        return pic2;
    }


    public void setPic2(String pic2) {
        this.pic2 = pic2;
    }

    @Column(name = "config")
    public String getConfig() {
        return config;
    }


    public void setConfig(String config) {
        this.config = config;
    }

    @Column(name = "content")
    public String getContent() {
        return content;
    }


    public void setContent(String content) {
        this.content = content;
    }

    @Column(name = "strategy")
    public String getStrategy() {
        return strategy;
    }


    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    @Column(name = "keyword_3")
    public String getKeyword3() {
        return keyword3;
    }


    public void setKeyword3(String keyword3) {
        this.keyword3 = keyword3;
    }

    @Column(name = "keyword_4")
    public String getKeyword4() {
        return keyword4;
    }


    public void setKeyword4(String keyword4) {
        this.keyword4 = keyword4;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

