package com.ptteng.micro.mall.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "box_sku_relation")
public class BoxSkuRelation implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 8709059647259145216L;

    public static final int IS_LAST_RATING = 1;
    public static final int NOT_LAST_RATING = 2;

    /**
     * 自增长ID
     */
    private Long id;


    /**
     * 箱号
     */
    private Long boxId;
    private Long campaignId;

    /**
     * skuId
     */
    private Long skuId;
    private String skuTitle;
    private Long spuId;
    private String spuTitle;

    private Double probability;
    private String displayProbability;
    /**
     * 赏级
     */
    private String rating;
    private String images;


    /**
     * 库存
     */
    private Integer stock;
    private Integer total;

    private Integer isLastRating;
    /**
     * 销量
     */
    private Integer sales = 0;


    /**
     * 备用1
     */
    private String keyword1;


    /**
     * 备用1
     */
    private String keyword2;


    /**
     * 备用1
     */
    private String keyword3;


    /**
     * 备用1
     */
    private String keyword4;


    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 创建人
     */
    private Long createBy;


    /**
     * 更新人
     */
    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "box_id")
    public Long getBoxId() {
        return boxId;
    }


    public void setBoxId(Long boxId) {
        this.boxId = boxId;
    }

    @Column(name = "campaign_id")
    public Long getCampaignId() {
        return campaignId;
    }

    public void setCampaignId(Long campaignId) {
        this.campaignId = campaignId;
    }

    @Column(name = "sku_id")
    public Long getSkuId() {
        return skuId;
    }


    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    @Transient
    public Long getSpuId() {
        return spuId;
    }

    public void setSpuId(Long spuId) {
        this.spuId = spuId;
    }

    @Transient
    public String getSkuTitle() {
        return skuTitle;
    }

    public void setSkuTitle(String skuTitle) {
        this.skuTitle = skuTitle;
    }

    @Transient
    public String getSpuTitle() {
        return spuTitle;
    }

    public void setSpuTitle(String spuTitle) {
        this.spuTitle = spuTitle;
    }

    @Transient
    public String getDisplayProbability() {
        return displayProbability;
    }

    public void setDisplayProbability(String displayProbability) {
        this.displayProbability = displayProbability;
    }

    @Column(name = "rating")
    public String getRating() {
        return rating;
    }


    public void setRating(String rating) {
        this.rating = rating;
    }

    @Column(name = "is_last_rating")
    public Integer getIsLastRating() {
        return isLastRating;
    }

    public void setIsLastRating(Integer isLastRating) {
        this.isLastRating = isLastRating;
    }

    @Column(name = "images")
    public String getImages() {
        return images;
    }

    public void setImages(String images) {
        this.images = images;
    }

    @Column(name = "stock")
    public Integer getStock() {
        return stock;
    }
    public void setStock(Integer stock) {
        this.stock = stock;
    }

    @Column(name = "total")
    public Integer getTotal() {
        return total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    @Column(name = "probability")
    public Double getProbability() {
        return probability;
    }

    public void setProbability(Double probability) {
        this.probability = probability;
    }

    @Column(name = "sales")
    public Integer getSales() {
        return sales;
    }


    public void setSales(Integer sales) {
        this.sales = sales;
    }

    @Column(name = "keyword_1")
    public String getKeyword1() {
        return keyword1;
    }


    public void setKeyword1(String keyword1) {
        this.keyword1 = keyword1;
    }

    @Column(name = "keyword_2")
    public String getKeyword2() {
        return keyword2;
    }


    public void setKeyword2(String keyword2) {
        this.keyword2 = keyword2;
    }

    @Column(name = "keyword_3")
    public String getKeyword3() {
        return keyword3;
    }


    public void setKeyword3(String keyword3) {
        this.keyword3 = keyword3;
    }

    @Column(name = "keyword_4")
    public String getKeyword4() {
        return keyword4;
    }


    public void setKeyword4(String keyword4) {
        this.keyword4 = keyword4;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

    public static enum RatingEnum {

        A(1, "A"),
        B(2, "B"),
        C(3, "C"),
        D(4, "D"),
        E(5, "E"),
        F(6, "F"),
        G(7, "G"),
        H(8, "H"),
        I(9, "I");

        RatingEnum(Integer key, String value) {
            this.key = key;
            this.value = value;
        }

        private Integer key;
        private String value;

        public Integer getKey() {
            return key;
        }

        public String getValue() {
            return value;
        }

        public static String getValueByKey(Integer key) {
            BoxSkuRelation.RatingEnum[] var1 = values();
            int var2 = var1.length;

            for (int var3 = 0; var3 < var2; ++var3) {
                BoxSkuRelation.RatingEnum ratingEnum = var1[var3];
                if (ratingEnum.getKey().equals(key)) {
                    return ratingEnum.getValue();
                }
            }
            return "";
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof BoxSkuRelation) {
            BoxSkuRelation boxSku = (BoxSkuRelation) obj;
            Long skuId = boxSku.getSkuId();
            String rating = boxSku.getRating();
            if (null == skuId || null == rating) {
                return false;
            }
            if (this.skuId.equals(skuId) && this.rating.equals(rating)) {
                return true;
            } else {
                return false;
            }
        }
        return super.equals(obj);
    }
}

