/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.micro.common.util;

import com.ptteng.micro.common.annotation.SensitiveInfo;
import com.ptteng.micro.common.annotation.SensitiveType;
import java.lang.reflect.Field;
import java.util.regex.Pattern;

public class SensitiveInfoUtils {
    public static <T> T mask(T obj) {
        Field[] fields;
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            SensitiveInfo sensitiveInfo = field.getAnnotation(SensitiveInfo.class);
            if (sensitiveInfo == null) continue;
            field.setAccessible(true);
            try {
                Object value = field.get(obj);
                if (value == null || !(value instanceof String)) continue;
                String maskedValue = SensitiveInfoUtils.mask((String)value, sensitiveInfo.type());
                field.set(obj, maskedValue);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return obj;
    }

    public static String mask(String value, SensitiveType type) {
        if (type == SensitiveType.PHONE) {
            String regex = "(\\d{3})\\d{4}(\\d{4})";
            String replacement = "$1****$2";
            return Pattern.compile(regex).matcher(value).replaceAll(replacement);
        }
        if (type == SensitiveType.EMAIL) {
            String[] parts = value.split("@");
            if (parts.length == 2) {
                String username = parts[0];
                String domain = parts[1];
                int len = username.length();
                if (len <= 2) {
                    return "*@" + domain;
                }
                String first = username.substring(0, 1);
                String last = username.substring(len - 1);
                return first + "****" + last + "@" + domain;
            }
            return value;
        }
        if (type == SensitiveType.ADDRESS) {
            String regex = "(\\d+)(\u53f7|\u697c|\u5355\u5143|\u5ba4)";
            String replacement = "$1*$2";
            return Pattern.compile(regex).matcher(value).replaceAll(replacement);
        }
        int len = value.length();
        if (len <= 1) {
            return "*";
        }
        int maskLen = Math.max(len / 2, 1);
        String prefix = value.substring(0, maskLen);
        String suffix = value.substring(len - maskLen);
        String middle = "";
        for (int i = 0; i < len - maskLen * 2; ++i) {
            middle = middle + "*";
        }
        return prefix + middle + suffix;
    }
}

