package com.ptteng.micro.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.micro.common.model.UserBusinessHistory;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface UserBusinessHistoryService extends BaseDaoService {

	



   		   
		
		public Long insert(UserBusinessHistory userBusinessHistory)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<UserBusinessHistory> insertList(List<UserBusinessHistory> userBusinessHistoryList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(UserBusinessHistory userBusinessHistory)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<UserBusinessHistory> userBusinessHistoryList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public UserBusinessHistory getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<UserBusinessHistory> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countUserBusinessHistoryIdsByUserId(Long userId)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countUserBusinessHistoryIdsByBusinessTypeAndBusinessId(Integer businessType, Long businessId)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countUserBusinessHistoryIdsByBusinessTypeAndBusinessIdAndUserId(Integer businessType, Long businessId, Long userId)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getUserBusinessHistoryIdsByUserId(Long userId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getUserBusinessHistoryIdsByBusinessTypeAndBusinessId(Integer businessType, Long businessId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getUserBusinessHistoryIdsByBusinessTypeAndBusinessIdAndUserId(Integer businessType, Long businessId, Long userId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;

	public List<Long>  getUserBusinessHistoryIdsByBusinessTypeAndTypeAndBusinessIdAndUserId(Integer businessType, Integer type, Long businessId, Long userId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;

	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getUserBusinessHistoryIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countUserBusinessHistoryIds() throws ServiceException, ServiceDaoException;
	

}

