package com.ptteng.micro.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.micro.common.model.Student;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface StudentService extends BaseDaoService {

	



   		   
		
		public Long insert(Student student)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Student> insertList(List<Student> studentList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Student student)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Student> studentList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Student getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Student> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countStudentIdsByMerchantIdAndUserId(Long merchantId, Long userId)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getStudentIdByMerchantIdAndIdNumber(Long merchantId, String idNumber)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getStudentIdsByMerchantIdAndUserId(Long merchantId, Long userId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getStudentIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countStudentIds() throws ServiceException, ServiceDaoException;
	

}

