package com.ptteng.micro.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "registration_record")
public class RegistrationRecord implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 3773403680741070848L;


    /**
     * 学生
     */
    public static final Integer BOUND_TYPE_STUDENT = 1;
    public static final Integer PRESCHOOL_GROUP = 1;
    public static final Integer TEENAGER_GROUP = 1;

    public static final Integer STATUS_JOIN = 1;
    public static final Integer STATUS_FLAG = 0;
    public static final Integer STATUS_SUBSCRIBE  = -1;
    public static final Integer SUBSCRIBE_TRUE  = 1;
    public static final Integer SHORTLIST_YES  = 1;
    public static final Integer SHORTLIST_NO  = 0;


    /**
     * 自增长ID
     */
    private Long id;


    /**
     * 商户id
     */
    private Long merchantId;


    /**
     * 用户id
     */
    private Long userId;


    /**
     * 绑定id
     */
    private Long boundId;


    /**
     * 绑定类型
     */
    private Integer boundType;


    /**
     * 报名状态
     */
    private Integer status;


    /**
     * 文档id
     */
    private Long docId;


    /**
     * 报名组
     */
    private Integer groupType;


    /**
     * 报名目标id
     */
    private Long registrationId;


    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 创建人
     */
    private Long createBy;


    /**
     * 更新人
     */
    private Long updateBy;
    /**
     *  预约
     */
    private Integer subscribe;
    /**
     *  入围
     */
    private Integer shortlist;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "merchant_id")
    public Long getMerchantId() {
        return merchantId;
    }


    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    @Column(name = "user_id")
    public Long getUserId() {
        return userId;
    }


    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Column(name = "bound_id")
    public Long getBoundId() {
        return boundId;
    }


    public void setBoundId(Long boundId) {
        this.boundId = boundId;
    }

    @Column(name = "bound_type")
    public Integer getBoundType() {
        return boundType;
    }


    public void setBoundType(Integer boundType) {
        this.boundType = boundType;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "doc_id")
    public Long getDocId() {
        return docId;
    }


    public void setDocId(Long docId) {
        this.docId = docId;
    }

    @Column(name = "group_type")
    public Integer getGroupType() {
        return groupType;
    }


    public void setGroupType(Integer groupType) {
        this.groupType = groupType;
    }

    @Column(name = "registration_id")
    public Long getRegistrationId() {
        return registrationId;
    }


    public void setRegistrationId(Long registrationId) {
        this.registrationId = registrationId;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }
    @Column(name = "subscribe")
    public Integer getSubscribe() {
        return subscribe;
    }

    public void setSubscribe(Integer subscribe) {
        this.subscribe = subscribe;
    }
    @Column(name = "shortlist")
    public Integer getShortlist() {
        return shortlist;
    }

    public void setShortlist(Integer shortlist) {
        this.shortlist = shortlist;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

