package com.ptteng.micro.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.micro.common.model.SubscribeTemplate;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface SubscribeTemplateService extends BaseDaoService {

	



   		   
		
		public Long insert(SubscribeTemplate subscribeTemplate)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<SubscribeTemplate> insertList(List<SubscribeTemplate> subscribeTemplateList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(SubscribeTemplate subscribeTemplate)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<SubscribeTemplate> subscribeTemplateList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public SubscribeTemplate getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<SubscribeTemplate> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countSubscribeTemplateIdsByAppId(String appId)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countSubscribeTemplateIdsByAppIdAndCategory(String appId, Integer category)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getSubscribeTemplateIdByAppIdAndTemplateId(String appId, String templateId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getSubscribeTemplateIdsByAppId(String appId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getSubscribeTemplateIdByAppIdAndCategoryAndType(String appId, Integer category, Integer type)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getSubscribeTemplateIdsByAppIdAndCategory(String appId, Integer category, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getSubscribeTemplateIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countSubscribeTemplateIds() throws ServiceException, ServiceDaoException;
	

}

