/**
 * 
 */
package com.ptteng.sca.micro.common.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.micro.common.model.Student;
import com.ptteng.micro.common.service.StudentService;

import java.util.List;
import java.util.Map;

public class StudentSCAClient implements StudentService {

    private StudentService studentService;

	public StudentService getStudentService() {
		return studentService;
	}
	
	
	public void setStudentService(StudentService studentService) {
		this.studentService =studentService;
	}
	
	
			   
		@Override
		public Long insert(Student student)throws ServiceException, ServiceDaoException{
		
		return studentService.insert(student);
		          
		
		}	
		  
    	   
		@Override
		public List<Student> insertList(List<Student> studentList)throws ServiceException, ServiceDaoException{
		
		return studentService.insertList(studentList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return studentService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Student student)throws ServiceException, ServiceDaoException{
		
		return studentService.update(student);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Student> studentList)throws ServiceException, ServiceDaoException{
		
		return studentService.updateList(studentList);
		          
		
		}	
		  
    	   
		@Override
		public Student getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return studentService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Student> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return studentService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getStudentIdByMerchantIdAndIdNumber(Long merchantId,String idNumber)throws ServiceException, ServiceDaoException{
		
		return studentService.getStudentIdByMerchantIdAndIdNumber(merchantId,idNumber);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getStudentIdsByMerchantIdAndUserId(Long merchantId,Long userId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return studentService.getStudentIdsByMerchantIdAndUserId(merchantId,userId,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countStudentIdsByMerchantIdAndUserId(Long merchantId,Long userId)throws ServiceException, ServiceDaoException{
		
		return studentService.countStudentIdsByMerchantIdAndUserId(merchantId,userId);
	
	
	}
	
		
	
		@Override
	public List<Long> getStudentIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return studentService.getStudentIds(start, limit);
	}

	@Override
	public Integer countStudentIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return studentService.countStudentIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return studentService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return studentService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   studentService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.studentService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}
	@Override
	public Object getMapListByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		return this.studentService.getMapListByDynamicCondition(clz, conditions, start, limit);
	}


 
}

