/**
 * 
 */
package com.ptteng.sca.micro.common.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.micro.common.model.Resource;
import com.ptteng.micro.common.service.ResourceService;

import java.util.List;
import java.util.Map;

public class ResourceSCAClient implements ResourceService {

    private ResourceService resourceService;

	public ResourceService getResourceService() {
		return resourceService;
	}
	
	
	public void setResourceService(ResourceService resourceService) {
		this.resourceService =resourceService;
	}
	
	
			   
		@Override
		public Long insert(Resource resource)throws ServiceException, ServiceDaoException{
		
		return resourceService.insert(resource);
		          
		
		}	
		  
    	   
		@Override
		public List<Resource> insertList(List<Resource> resourceList)throws ServiceException, ServiceDaoException{
		
		return resourceService.insertList(resourceList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return resourceService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Resource resource)throws ServiceException, ServiceDaoException{
		
		return resourceService.update(resource);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Resource> resourceList)throws ServiceException, ServiceDaoException{
		
		return resourceService.updateList(resourceList);
		          
		
		}	
		  
    	   
		@Override
		public Resource getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return resourceService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Resource> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return resourceService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getResourceIdsByVideoId(String videoId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return resourceService.getResourceIdsByVideoId(videoId,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getResourceIdsByVideoIdAndEventType(String videoId,String eventType,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return resourceService.getResourceIdsByVideoIdAndEventType(videoId,eventType,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countResourceIdsByVideoId(String videoId)throws ServiceException, ServiceDaoException{
		
		return resourceService.countResourceIdsByVideoId(videoId);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countResourceIdsByVideoIdAndEventType(String videoId,String eventType)throws ServiceException, ServiceDaoException{
		
		return resourceService.countResourceIdsByVideoIdAndEventType(videoId,eventType);
	
	
	}
	
		
	
		@Override
	public List<Long> getResourceIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return resourceService.getResourceIds(start, limit);
	}

	@Override
	public Integer countResourceIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return resourceService.countResourceIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return resourceService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return resourceService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   resourceService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.resourceService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}
	@Override
	public Object getMapListByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		return this.resourceService.getMapListByDynamicCondition(clz, conditions, start, limit);
	}


 
}

