package com.ptteng.micro.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.micro.common.model.SubscribeMsg;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface SubscribeMsgService extends BaseDaoService {

	



   		   
		
		public Long insert(SubscribeMsg subscribeMsg)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<SubscribeMsg> insertList(List<SubscribeMsg> subscribeMsgList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(SubscribeMsg subscribeMsg)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<SubscribeMsg> subscribeMsgList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public SubscribeMsg getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<SubscribeMsg> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countSubscribeMsgIdsByUserIdAndMerchantId(Long userId, Long merchantId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countSubscribeMsgIdsByUserIdAndMerchantIdAndCategory(Long userId, Long merchantId, Integer category)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getSubscribeMsgIdsByUserIdAndMerchantId(Long userId, Long merchantId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getSubscribeMsgIdByUserIdAndMerchantIdAndCategoryAndType(Long userId, Long merchantId, Integer category, Integer type)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getSubscribeMsgIdsByUserIdAndMerchantIdAndCategory(Long userId, Long merchantId, Integer category, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getSubscribeMsgIdByUserIdAndTemplateId(Long userId, String templateId)throws ServiceException, ServiceDaoException;
	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getSubscribeMsgIdByUserIdAndAppIdAndTemplateId(Long userId, String appId,String templateId)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getSubscribeMsgIdByUserIdAndAppIdAndCategoryAndType(Long userId, String appId,Integer category,Integer type)throws ServiceException, ServiceDaoException;


	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getSubscribeMsgIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countSubscribeMsgIds() throws ServiceException, ServiceDaoException;
	

}

