package com.ptteng.micro.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.micro.common.model.ExtraTemp;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface ExtraTempService extends BaseDaoService {
    public Long insert(ExtraTemp extraTemp)throws ServiceException, ServiceDaoException;

    public List<ExtraTemp> insertList(List<ExtraTemp> extraTempList)throws ServiceException, ServiceDaoException;



    public boolean delete(Long id)throws ServiceException, ServiceDaoException;



    public boolean update(ExtraTemp extraTemp)throws ServiceException, ServiceDaoException;



    public boolean updateList(List<ExtraTemp> extraTempList)throws ServiceException, ServiceDaoException;



    public ExtraTemp getObjectById(Long id)throws ServiceException, ServiceDaoException;



    public List<ExtraTemp> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;

    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getExtraTempIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countExtraTempIds() throws ServiceException, ServiceDaoException;

    public List<Long> getExtraTempIdsByTempId(Long tempId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;
    public Integer countExtraTempIdsByTempId(Long tempId) throws ServiceException, ServiceDaoException;

    public List<Long> getExtraTempIdsByTempIdAndType(Long tempId, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException;
    public Integer countExtraTempIdsByTempIdAndType(Long tempId, Integer type) throws ServiceException, ServiceDaoException;
}
