package com.ptteng.micro.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "user_business_history")
public class UserBusinessHistory implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 4666406213337907200L;	
	
		
	/**
	 *  内容
	 * 
	 */
	public static final Integer BUSINESS_TYPE_CONTENTS = 1;
    	
	/**
	 *  作品
	 * 
	 */
	public static final Integer BUSINESS_TYPE_DOC = 2;
    	
	/**
	 *  点赞
	 * 
	 */
	public static final Integer TYPE_FAVOR = 2;
    	
	/**
	 *  投票
	 * 
	 */
	public static final Integer TYPE_VOTE = 3;
    	
	/**
	 *  取消
	 * 
	 */
	public static final Integer STATUS_NO = 0;
    	
	/**
	 *  正常
	 * 
	 */
	public static final Integer STATUS_YES = 1;
    	
	/**
	 *  收藏
	 * 
	 */
	public static final Integer TYPE_COLLECT = 1;
    	
   
   /**
   *  自增长ID
   *
   */
    private  Long id;
	
  
   /**
   *  业务id
   *
   */
    private  Long businessId;
	
  
   /**
   *  用户id
   *
   */
    private  Long userId;
	
  
   /**
   *  操作
   *
   */
    private  Integer status;
	
  
   /**
   *  操作类型
   *
   */
    private  Integer type;
	
  
   /**
   *  业务类型
   *
   */
    private  Integer businessType;
	
  
   /**
   *  创建时间
   *
   */
    private  Long createAt;
	
  
   /**
   *  更新时间
   *
   */
    private  Long updateAt;
	
  
   /**
   *  创建人
   *
   */
    private  Long createBy;
	
  
   /**
   *  更新人
   *
   */
    private  Long updateBy;
	
  
	
		 	
         	 	   @Id
     	   @GeneratedValue(strategy = GenerationType.AUTO)
              	@Column(name = "id")
	public Long getId() {
		return id;
	}
	
	
	public void setId(Long id) {
		this.id = id;
	}
		 	@Column(name = "business_id")
	public Long getBusinessId() {
		return businessId;
	}
	
	
	public void setBusinessId(Long businessId) {
		this.businessId = businessId;
	}
		 	@Column(name = "user_id")
	public Long getUserId() {
		return userId;
	}
	
	
	public void setUserId(Long userId) {
		this.userId = userId;
	}
		 	@Column(name = "status")
	public Integer getStatus() {
		return status;
	}
	
	
	public void setStatus(Integer status) {
		this.status = status;
	}
		 	@Column(name = "type")
	public Integer getType() {
		return type;
	}
	
	
	public void setType(Integer type) {
		this.type = type;
	}
		 	@Column(name = "business_type")
	public Integer getBusinessType() {
		return businessType;
	}
	
	
	public void setBusinessType(Integer businessType) {
		this.businessType = businessType;
	}
		 	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}
	
	
	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}
		 	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}
	
	
	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}
		 	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}
	
	
	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
		 	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}
	
	
	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
		
	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}

}

