package com.ptteng.micro.common.service;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.micro.common.model.TempData;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface TempDataService extends BaseDaoService {
    public Long insert(TempData tempData)throws ServiceException, ServiceDaoException;

    public List<TempData> insertList(List<TempData> tempDataList)throws ServiceException, ServiceDaoException;



    public boolean delete(Long id)throws ServiceException, ServiceDaoException;



    public boolean update(TempData tempData)throws ServiceException, ServiceDaoException;



    public boolean updateList(List<TempData> tempDataList)throws ServiceException, ServiceDaoException;



    public TempData getObjectById(Long id)throws ServiceException, ServiceDaoException;



    public List<TempData> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;

    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getTempDataIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countTempDataIds() throws ServiceException, ServiceDaoException;

    public List<Long> getTempDataIdsByTempId(Long tempId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;
    public Integer countTempDataIdsByTempId(Long tempId) throws ServiceException, ServiceDaoException;
    public Long getTempDataIdByCode(String code) throws ServiceException, ServiceDaoException;
}
