package com.ptteng.micro.common.model;


import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;

@Entity
@Table(name = "temp_data")
public class TempData implements Serializable {
    public static final String COUNTED = "0,0";

    /**
     * 自增id
     */
    private Long id;

    /**
     * 模板id
     */
    private Long tempId;

    /**
     * 唯一编码
     */
    private String code;

    /**
     * 字段数据json
     */
    private String dataJson;

    /**
     * 打印份数
     */
    private Long count;

    /**
     * 已打印份数
     */
    private String counted;

    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 创建者
     */
    private Long createBy;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 更新者
     */
    private Long updateBy;



    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }
    @Column(name = "temp_id")
    public Long getTempId() {
        return tempId;
    }

    public void setTempId(Long tempId) {
        this.tempId = tempId;
    }

    @Column(name = "code")
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Column(name = "data_json")
    public String getDataJson() {
        return dataJson;
    }

    public void setDataJson(String dataJson) {
        this.dataJson = dataJson;
    }

    @Column(name = "count")
    public Long getCount() {
        return count;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    @Column(name = "counted")
    public String getCounted() {
        return counted;
    }

    public void setCounted(String counted) {
        this.counted = counted;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }

    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }

    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }
}
