package com.ptteng.sca.micro.common.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.micro.common.model.TempData;
import com.ptteng.micro.common.service.TempDataService;


import java.util.List;
import java.util.Map;

public class TempDataSCAClient implements TempDataService {
    private TempDataService tempDataService;

    public TempDataService getTempDataService() {return tempDataService;}

    public void setTempDataService(TempDataService tempDataService) {this.tempDataService = tempDataService;}

    @Override
    public Long insert(TempData tempData)throws ServiceException, ServiceDaoException {

        return tempDataService.insert(tempData);


    }


    @Override
    public List<TempData> insertList(List<TempData> tempDataList)throws ServiceException, ServiceDaoException{

        return tempDataService.insertList(tempDataList);


    }


    @Override
    public boolean delete(Long id)throws ServiceException, ServiceDaoException{

        return tempDataService.delete(id);


    }


    @Override
    public boolean update(TempData tempData)throws ServiceException, ServiceDaoException{

        return tempDataService.update(tempData);


    }


    @Override
    public boolean updateList(List<TempData> tempDataList)throws ServiceException, ServiceDaoException{

        return tempDataService.updateList(tempDataList);


    }


    @Override
    public TempData getObjectById(Long id)throws ServiceException, ServiceDaoException{

        return tempDataService.getObjectById(id);


    }


    @Override
    public List<TempData> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{

        return tempDataService.getObjectsByIds(ids);


    }


    @Override
    public List<Long> getTempDataIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return tempDataService.getTempDataIds(start, limit);
    }

    @Override
    public Integer countTempDataIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return tempDataService.countTempDataIds();
    }




    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return tempDataService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return tempDataService.fakeDelete(clz, id);
    }



    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        tempDataService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.tempDataService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public List<Long> getTempDataIdsByTempId(Long tempId,Integer start, Integer limit) throws ServiceException, ServiceDaoException{
        return tempDataService.getTempDataIdsByTempId(tempId, start, limit);
    }
    @Override
    public Integer countTempDataIdsByTempId(Long tempId) throws ServiceException, ServiceDaoException {
        return tempDataService.countTempDataIdsByTempId(tempId);
    }

    @Override
    public Long getTempDataIdByCode(String code) throws ServiceException, ServiceDaoException {
        return tempDataService.getTempDataIdByCode(code);
    }

}
