package com.ptteng.micro.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;


@Entity
@Table(name = "template_jp")
public class TemplateJp implements Serializable {

  /**
   * 0：普通模板
   */
  public static final Integer ORDINARY_TEMPLATE = 0;

  /**
   * 10=行业模板
   */
  public static final Integer INDUSTRY_TEMPLATE = 10;

  /**
   *
   */


  /**
   * 前端组件约定：4 列表
   */
  public static final Integer COMPONENT_ID_4 = 4;

  /**
   * 前端组件样式约定：3
   */
  public static final Integer COMPONENT_STYLE_3 = 3;

  public static final Integer CLASSIFY_LIST = 6;

  //
  private static final Integer contact_us  = 5;

  /**
   * 小程序端模板
   */
  public static final Integer APPLETS = 0;

  /**
   * PC端模板
   */
  public static final Integer PC = 1;
    private static final long serialVersionUID = -3493808106802081665L;

    /**
   * 主键,自增长ID
   */
  private Long id;


  /**
   * 模板名
   */
  private String name;


  /**
   * 商户id
   */
  private Long merchantId;


  /**
   * 模板json
   */
  private String moduleJson;

    /**
     * 模板json
     */
    private String moduleJsonLangInfo;
  /**
   * 模板类型 0：普通模板  10=行业模板
   */
  private Integer type;

  /**
   * 0=小程序端模板  1=PC端模板
   */
  private Integer category;


  /**
   * 创建时间
   */
  private Long createAt;


  /**
   * 创建者
   */
  private Long createBy;


  /**
   * 更新时间
   */
  private Long updateAt;


  /**
   * 更新者
   */
  private Long updateBy;


  @Id
  @Column(name = "id")
  public Long getId() {
    return id;
  }


  public TemplateJp setId(Long id) {
    this.id = id;
    return this;
  }

  @Column(name = "name")
  public String getName() {
    return name;
  }


  public TemplateJp setName(String name) {
    this.name = name;
    return this;
  }

  @Column(name = "merchant_id")
  public Long getMerchantId() {
    return merchantId;
  }


  public TemplateJp setMerchantId(Long merchantId) {
    this.merchantId = merchantId;
    return this;
  }

  @Column(name = "module_json")
  public String getModuleJson() {
    return moduleJson;
  }


  public TemplateJp setModuleJson(String moduleJson) {
    this.moduleJson = moduleJson;
    return this;
  }

  @Column(name = "type")
  public Integer getType() {
    return type;
  }

  public void setType(Integer type) {
    this.type = type;
  }

  @Column(name = "category")
  public Integer getCategory() {
    return category;
  }

  public void setCategory(Integer category) {
    this.category = category;
  }

  @Column(name = "create_at")
  public Long getCreateAt() {
    return createAt;
  }


  public TemplateJp setCreateAt(Long createAt) {
    this.createAt = createAt;
    return this;
  }

  @Column(name = "create_by")
  public Long getCreateBy() {
    return createBy;
  }


  public TemplateJp setCreateBy(Long createBy) {
    this.createBy = createBy;
    return this;
  }

  @Column(name = "update_at")
  public Long getUpdateAt() {
    return updateAt;
  }


  public TemplateJp setUpdateAt(Long updateAt) {
    this.updateAt = updateAt;
    return this;
  }

  @Column(name = "update_by")
  public Long getUpdateBy() {
    return updateBy;
  }


  public TemplateJp setUpdateBy(Long updateBy) {
    this.updateBy = updateBy;
    return this;
  }
    @Column(name = "module_json_lang_info")
    public String getModuleJsonLangInfo() {
        return moduleJsonLangInfo;
    }

    public void setModuleJsonLangInfo(String moduleJsonLangInfo) {
        this.moduleJsonLangInfo = moduleJsonLangInfo;
    }

    @Override
  public String toString() {
    return ToStringBuilder.reflectionToString(this,
        ToStringStyle.MULTI_LINE_STYLE);
  }

}

