/**
 *
 */
package com.ptteng.sca.micro.common.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.micro.common.model.Merchant;
import com.ptteng.micro.common.service.MerchantService;

import java.util.List;
import java.util.Map;

public class MerchantSCAClient implements MerchantService {

    private MerchantService merchantService;

    public MerchantService getMerchantService() {
        return merchantService;
    }


    public void setMerchantService(MerchantService merchantService) {
        this.merchantService = merchantService;
    }


    @Override
    public Long insert(Merchant merchant) throws ServiceException, ServiceDaoException {

        return merchantService.insert(merchant);


    }


    @Override
    public List<Merchant> insertList(List<Merchant> merchantList) throws ServiceException, ServiceDaoException {

        return merchantService.insertList(merchantList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return merchantService.delete(id);


    }


    @Override
    public boolean update(Merchant merchant) throws ServiceException, ServiceDaoException {

        return merchantService.update(merchant);


    }


    @Override
    public boolean updateList(List<Merchant> merchantList) throws ServiceException, ServiceDaoException {

        return merchantService.updateList(merchantList);


    }


    @Override
    public Merchant getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return merchantService.getObjectById(id);


    }


    @Override
    public List<Merchant> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return merchantService.getObjectsByIds(ids);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getMerchantIdsByAppId(String appId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return merchantService.getMerchantIdsByAppId(appId, start, limit);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getMerchantIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return merchantService.getMerchantIdsByUid(uid, start, limit);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countMerchantIdsByAppId(String appId) throws ServiceException, ServiceDaoException {

        return merchantService.countMerchantIdsByAppId(appId);


    }

    @Override
    public List<Long> getMerchantIdsByAliAppId(String aliAppId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return merchantService.getMerchantIdsByAliAppId(aliAppId, start, limit);
    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countMerchantIdsByUid(Long uid) throws ServiceException, ServiceDaoException {

        return merchantService.countMerchantIdsByUid(uid);


    }


    @Override
    public List<Long> getMerchantIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return merchantService.getMerchantIds(start, limit);
    }

    @Override
    public Integer countMerchantIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return merchantService.countMerchantIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return merchantService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return merchantService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        merchantService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.merchantService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }


}

