package com.ptteng.micro.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.micro.common.model.UserRoleRelation;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface UserRoleRelationService extends BaseDaoService {

	



   		   
		
		public Long insert(UserRoleRelation userRoleRelation)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<UserRoleRelation> insertList(List<UserRoleRelation> userRoleRelationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(UserRoleRelation userRoleRelation)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<UserRoleRelation> userRoleRelationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public UserRoleRelation getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<UserRoleRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countUserRoleRelationIdsByUserIdAndRoleIdAndMerchantId(Long userId, Long roleId, Long merchantId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countUserRoleRelationIdsByUserIdAndMerchantId(Long userId, Long merchantId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getUserRoleRelationIdsByUserIdAndRoleIdAndMerchantId(Long userId, Long roleId, Long merchantId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getUserRoleRelationIdsByUserIdAndMerchantId(Long userId, Long merchantId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getUserRoleRelationIdsByRoleId(Long roleId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;

	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getUserRoleRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countUserRoleRelationIds() throws ServiceException, ServiceDaoException;
	

}

