package com.ptteng.micro.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.micro.common.model.Gcomponent;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface GcomponentService extends BaseDaoService {


  public Long insert(Gcomponent gcomponent) throws ServiceException, ServiceDaoException;


  public List<Gcomponent> insertList(List<Gcomponent> gcomponentList) throws ServiceException, ServiceDaoException;


  public boolean delete(Long id) throws ServiceException, ServiceDaoException;


  public boolean update(Gcomponent gcomponent) throws ServiceException, ServiceDaoException;


  public boolean updateList(List<Gcomponent> gcomponentList) throws ServiceException, ServiceDaoException;


  public Gcomponent getObjectById(Long id) throws ServiceException, ServiceDaoException;


  public List<Gcomponent> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


  /**
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  public Integer countGcomponentIdsByMerchantIdAndTypeAndKeyAndLevel(Long merchantId, Integer type, String key, Integer level) throws ServiceException, ServiceDaoException;


  /**
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  public Integer countGcomponentIdsByMerchantIdAndKey(Long merchantId, String key) throws ServiceException, ServiceDaoException;


  /**
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  public Integer countGcomponentIdsByMerchantIdAndTypeAndKey(Long merchantId, Integer type, String key) throws ServiceException, ServiceDaoException;


  /**
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  public Integer countGcomponentIdsByMerchantId(Long merchantId) throws ServiceException, ServiceDaoException;


  /**
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  public Integer countGcomponentIdsByMerchantIdAndLevel(Long merchantId, Integer level) throws ServiceException, ServiceDaoException;


  /**
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  public Integer countGcomponentIdsByMerchantIdAndType(Long merchantId, Integer type) throws ServiceException, ServiceDaoException;


  /**
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  public List<Long> getGcomponentIdsByMerchantIdAndTypeAndKeyAndLevel(Long merchantId, Integer type, String key, Integer level, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


  /**
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  public List<Long> getGcomponentIdsByMerchantIdAndKey(Long merchantId, String key, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


  /**
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  public List<Long> getGcomponentIdsByMerchantIdAndTypeAndKey(Long merchantId, Integer type, String key, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


  /**
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  public List<Long> getGcomponentIdsByMerchantId(Long merchantId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


  /**
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  public List<Long> getGcomponentIdsByMerchantIdAndLevel(Long merchantId, Integer level, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


  /**
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  public List<Long> getGcomponentIdsByMerchantIdAndType(Long merchantId, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


  /**
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  public List<Long> getGcomponentIds(Integer start, Integer limit)
          throws ServiceException, ServiceDaoException;

  /**
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  public Integer countGcomponentIds() throws ServiceException, ServiceDaoException;


}

