package com.ptteng.micro.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "moments")
public class Moments implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 295561944656216064L;


    /**
     * 自增长ID
     */
    private Long id;


    /**
     * 员工姓名
     */
    private Long userId;
    private Long merchantId;


    /**
     * 手机号
     */
    private String contents;


    private Integer picCount;

    /**
     * 备用字段
     */
    private String jsonInfo;


    /**
     * 创建人ID
     */
    private Long createBy;


    /**
     * 更新人ID
     */
    private Long updateBy;


    /**
     * 数据更新时间
     */
    private Long updateAt;


    /**
     * 创建时间
     */
    private Long createAt;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }

    @Column(name = "contents")
    public String getContents() {
        return contents;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "user_id")
    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Column(name = "merchant_id")
    public Long getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    public void setContents(String contents) {
        this.contents = contents;
    }

    @Column(name = "pic_count")
    public Integer getPicCount() {
        return picCount;
    }

    public void setPicCount(Integer picCount) {
        this.picCount = picCount;
    }

    @Column(name = "json_info")
    public String getJsonInfo() {
        return jsonInfo;
    }


    public void setJsonInfo(String jsonInfo) {
        this.jsonInfo = jsonInfo;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

