package com.ptteng.micro.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.micro.common.model.User;

import java.util.List;

import org.osoa.sca.annotations.Remotable;

@Remotable
public interface UserService extends BaseDaoService {


    public Long insert(User user) throws ServiceException, ServiceDaoException;


    public List<User> insertList(List<User> userList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(User user) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<User> userList) throws ServiceException, ServiceDaoException;


    public User getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<User> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countUserIdsByUid(Long uid) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countUserIdsByAppId(String appId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserIdsByAppId(String appId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countUserIds() throws ServiceException, ServiceDaoException;

	Long getUserIdByMobile(String var1) throws ServiceException, ServiceDaoException;


}

