package com.ptteng.micro.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.micro.common.model.Merchant;
import java.util.List;
import org.osoa.sca.annotations.Remotable;

@Remotable
public interface MerchantService extends BaseDaoService {

	



   		   
		
		public Long insert(Merchant merchant)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Merchant> insertList(List<Merchant> merchantList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Merchant merchant)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Merchant> merchantList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Merchant getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Merchant> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countMerchantIdsByAppId(String appId)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countMerchantIdsByUid(Long uid)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getMerchantIdsByAppId(String appId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getMerchantIdsByUid(Long uid, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getMerchantIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countMerchantIds() throws ServiceException, ServiceDaoException;
	

}

