package com.ptteng.micro.common.model;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "merchant")
public class Merchant implements Serializable {

  /**
   *
   */
  private static final long serialVersionUID = 4278977928020689920L;

  public static final Integer USE = 10;

  public static final Integer EXPIRE = 20;

  public static final Integer ALL = 0;

  /**
   * 主键,自增长ID
   */
  private Long id;

  private String name;
  /**
   * 用户ID
   */
  private Long uid;


  /**
   * 用户状态
   */
  private Integer status;


  /**
   * 微信 appid
   */
  private String appId;


  /**
   * 微信 appsecret
   */
  private String appSecret;


  /**
   * 购买次数
   */
  private Integer purchaseTime;


  /**
   * 总金额
   */
  private BigDecimal totalAmount;

  /**
   * 行业模板ID
   */
  private Long industryTemplateId;


  /**
   * 商户号起始时间
   */
  private Long startAt;


  /**
   * 商户号到期时间
   */
  private Long endAt;

  /**
   * 分享文案
   */
  private String shareContents;

  /**
   * 小程序logo
   */
  private String logo;

  /**
   * PC端首页模板ID
   */
  private Long homepageTemplateId;

  /**
   * 商户PC域名
   */
  private String domainName;

  /**
   * 创建时间
   */
  private Long createAt;


  /**
   * 创建者
   */
  private Long createBy;


  /**
   * 更新时间
   */
  private Long updateAt;


  /**
   * 更新者
   */
  private Long updateBy;

  /**
   * 公司名称
   */
  private String companyName;
  /**
   * 公司简称
   */
  private String companyAbbreviation;
  /**
   * 法人手机号
   */
  private String legalPersonPhone;
  /**
   * 法人邮箱
   */
  private String legalPersonMail;
  /**
   * 扩展字符串(存储身份证照片,营业执照,开户许可证等)
   */
  private String extend;


  @Id
  @GeneratedValue(strategy = GenerationType.AUTO)
  @Column(name = "id")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @Column(name = "name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @Column(name = "uid")
  public Long getUid() {
    return uid;
  }


  public void setUid(Long uid) {
    this.uid = uid;
  }

  @Column(name = "status")
  public Integer getStatus() {
    return status;
  }


  public void setStatus(Integer status) {
    this.status = status;
  }

  @Column(name = "app_id")
  public String getAppId() {
    return appId;
  }


  public void setAppId(String appId) {
    this.appId = appId;
  }

  @Column(name = "app_secret")
  public String getAppSecret() {
    return appSecret;
  }


  public void setAppSecret(String appSecret) {
    this.appSecret = appSecret;
  }

  @Column(name = "purchase_time")
  public Integer getPurchaseTime() {
    return purchaseTime;
  }


  public void setPurchaseTime(Integer purchaseTime) {
    this.purchaseTime = purchaseTime;
  }

  @Column(name = "total_amount")
  public BigDecimal getTotalAmount() {
    return totalAmount;
  }


  public void setTotalAmount(BigDecimal totalAmount) {
    this.totalAmount = totalAmount;
  }

  @Column(name = "start_at")
  public Long getStartAt() {
    return startAt;
  }


  public void setStartAt(Long startAt) {
    this.startAt = startAt;
  }

  @Column(name = "end_at")
  public Long getEndAt() {
    return endAt;
  }


  public void setEndAt(Long endAt) {
    this.endAt = endAt;
  }

  @Column(name = "logo")
  public String getLogo() {
    return logo;
  }

  public void setLogo(String logo) {
    this.logo = logo;
  }


  @Column(name = "homepage_template_id")
  public Long getHomepageTemplateId() {
    return homepageTemplateId;
  }

  public void setHomepageTemplateId(Long homepageTemplateId) {
    this.homepageTemplateId = homepageTemplateId;
  }

  @Column(name = "create_at")
  public Long getCreateAt() {
    return createAt;
  }


  public void setCreateAt(Long createAt) {
    this.createAt = createAt;
  }

  @Column(name = "create_by")
  public Long getCreateBy() {
    return createBy;
  }


  public void setCreateBy(Long createBy) {
    this.createBy = createBy;
  }

  @Column(name = "update_at")
  public Long getUpdateAt() {
    return updateAt;
  }


  public void setUpdateAt(Long updateAt) {
    this.updateAt = updateAt;
  }

  @Column(name = "update_by")
  public Long getUpdateBy() {
    return updateBy;
  }

  public void setUpdateBy(Long updateBy) {
    this.updateBy = updateBy;
  }

  @Column(name = "company_name")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @Column(name = "company_abbreviation")
  public String getCompanyAbbreviation() {
    return companyAbbreviation;
  }

  public void setCompanyAbbreviation(String companyAbbreviation) {
    this.companyAbbreviation = companyAbbreviation;
  }

  @Column(name = "legal_person_phone")
  public String getLegalPersonPhone() {
    return legalPersonPhone;
  }

  public void setLegalPersonPhone(String legalPersonPhone) {
    this.legalPersonPhone = legalPersonPhone;
  }

  @Column(name = "legal_person_mail")
  public String getLegalPersonMail() {
    return legalPersonMail;
  }

  public void setLegalPersonMail(String legalPersonMail) {
    this.legalPersonMail = legalPersonMail;
  }


  @Column(name = "domain_name")
  public String getDomainName() {
    return domainName;
  }

  public void setDomainName(String domainName) {
    this.domainName = domainName;
  }

  @Column(name = "extend")
  public String getExtend() {
    return extend;
  }

  public void setExtend(String extend) {
    this.extend = extend;
  }

  @Column(name = "share_contents")
  public String getShareContents() {
    return shareContents;
  }

  public void setShareContents(String shareContents) {
    this.shareContents = shareContents;
  }

  @Column(name = "industry_template_id")
  public Long getIndustryTemplateId() {
    return industryTemplateId;
  }

  public void setIndustryTemplateId(Long industryTemplateId) {
    this.industryTemplateId = industryTemplateId;
  }

  public String toString() {
    return ToStringBuilder.reflectionToString(this,
        ToStringStyle.MULTI_LINE_STYLE);
  }

}

