package com.ptteng.micro.common.model;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "menu")
public class Menu implements Serializable {

  /**
   * 0：普通菜单
   */
  public static final Integer ORDINARY_MENU = 0;

  /**
   * 10=行业菜单
   */
  public static final Integer INDUSTRY_MENU = 10;

  /**
   * 上架状态
   */
  public static final Integer STATUS_ON = 1;
  /**
   * 下架状态
   */
  public static final Integer STATUS_OFF = 0;
  /**
   *
   */
  private static final long serialVersionUID = 7440197337284920320L;
  /**
   * 主键,自增长ID
   */
  private Long id;


  /**
   * 菜单名
   */
  private String name;


  /**
   * 菜单icon
   */
  private String icon;


  /**
   * 模板id
   */
  private Long templateId;


  /**
   * 商户id
   */
  private Long merchantId;


  /**
   * 序号 影响到前台页面的显示
   */
  private Long sort;


  /**
   * 上下架状态
   */
  private Integer status;

  /**
   * 菜单类型 0：普通菜单  10=行业菜单
   */
  private Integer type;


  /**
   * 创建时间
   */
  private Long createAt;


  /**
   * 创建者
   */
  private Long createBy;


  /**
   * 更新时间
   */
  private Long updateAt;


  /**
   * 更新者
   */
  private Long updateBy;


  @Id
  @GeneratedValue(strategy = GenerationType.AUTO)
  @Column(name = "id")
  public Long getId() {
    return id;
  }


  public Menu setId(Long id) {
    this.id = id;
    return this;
  }

  @Column(name = "name")
  public String getName() {
    return name;
  }


  public Menu setName(String name) {
    this.name = name;
    return this;
  }

  @Column(name = "icon")
  public String getIcon() {
    return icon;
  }


  public Menu setIcon(String icon) {
    this.icon = icon;
    return this;
  }

  @Column(name = "template_id")
  public Long getTemplateId() {
    return templateId;
  }


  public Menu setTemplateId(Long templateId) {
    this.templateId = templateId;
    return this;
  }

  @Column(name = "merchant_id")
  public Long getMerchantId() {
    return merchantId;
  }


  public Menu setMerchantId(Long merchantId) {
    this.merchantId = merchantId;
    return this;
  }

  @Column(name = "sort")
  public Long getSort() {
    return sort;
  }


  public Menu setSort(Long sort) {
    this.sort = sort;
    return this;
  }

  @Column(name = "status")
  public Integer getStatus() {
    return status;
  }


  public Menu setStatus(Integer status) {
    this.status = status;
    return this;
  }

  @Column(name = "type")
  public Integer getType() {
    return type;
  }

  public void setType(Integer type) {
    this.type = type;
  }

  @Column(name = "create_at")
  public Long getCreateAt() {
    return createAt;
  }


  public Menu setCreateAt(Long createAt) {
    this.createAt = createAt;
    return this;
  }

  @Column(name = "create_by")
  public Long getCreateBy() {
    return createBy;
  }


  public Menu setCreateBy(Long createBy) {
    this.createBy = createBy;
    return this;
  }

  @Column(name = "update_at")
  public Long getUpdateAt() {
    return updateAt;
  }


  public Menu setUpdateAt(Long updateAt) {
    this.updateAt = updateAt;
    return this;
  }

  @Column(name = "update_by")
  public Long getUpdateBy() {
    return updateBy;
  }


  public Menu setUpdateBy(Long updateBy) {
    this.updateBy = updateBy;
    return this;
  }

  public String toString() {
    return ToStringBuilder.reflectionToString(this,
        ToStringStyle.MULTI_LINE_STYLE);
  }

}

